<?php

namespace App\Controllers\backend;

use PHPExcel;
use PHPExcel_IOFactory;
use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\BerkasModel;
use CodeIgniter\Controller;


class Capes extends Controller
{

    protected $loginModel;
    protected $capesModel;
    protected $berkasModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->berkasModel = new BerkasModel();
    }

    public function index()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Calon Peserta Didik',
            'user' => $cekuser
        ];

        return view('backend/capes', $data);
    }

    public function fetchcapessemua()
    {
        if ($this->request->isAJAX()) {
            if ($capes = $this->capesModel->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'capes' => $capes
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function fetchcapesbelum()
    {
        if ($this->request->isAJAX()) {
            if ($capes = $this->capesModel->where('status_pembayaran', 'belum')->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'capes' => $capes
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function fetchcapessudah()
    {
        if ($this->request->isAJAX()) {
            if ($capes = $this->capesModel->where('status_pembayaran', 'sudah')->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'capes' => $capes
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function savecapes()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([

                'nik' => [
                    'rules' => 'required|is_unique[capes.nik]',
                    'errors' => [
                        'required' => 'NIK tidak boleh kosong',
                        'is_unique' => 'NIK Registrasi sudah ada'
                    ]
                ],
                'no_va' => [
                    'rules' => 'required|is_unique[capes.no_va]',
                    'errors' => [
                        'required' => 'Nomor VA tidak boleh kosong',
                        'is_unique' => 'Nomor VA sudah ada'
                    ]
                ],
                'nama_lengkap' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Nama tidak boleh kosong'
                    ]
                ],
                'email' => [
                    'rules' => 'required|valid_email',
                    'errors' => [
                        'required' => 'Email tidak boleh kosong',
                        'valid_email' => 'Email tidak valid'
                    ]
                ],
                'kelas' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Kelas tidak boleh kosong'
                    ]
                ],
                'divisi' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Divisi tidak boleh kosong'
                    ]
                ],
                'status_pembayaran' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Status tidak boleh kosong'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses

                $insert = $this->request->getVar();


                $this->capesModel->insert($insert);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'Calon Peserta Didik berhasil ditambah'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editmodal()
    {
        if ($this->request->isAJAX()) {
            $idcapes = $this->request->getVar('idcapes');
            if ($capes = $this->capesModel->where('id', $idcapes)->get()->getRowArray()) {
                $data = [
                    'responce' => 'success',
                    'capes' => $capes
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal memunculkan modal edit data'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editcapes()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([

                'nik' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'NIK tidak boleh kosong'
                    ]
                ],
                'no_va' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Nomor VA tidak boleh kosong'
                    ]
                ],
                'nama_lengkap' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Nama harus dipilih'
                    ]
                ],
                'email' => [
                    'rules' => 'required|valid_email',
                    'errors' => [
                        'required' => 'Email tidak boleh kosong',
                        'valid_email' => 'Email tidak valid'
                    ]
                ],
                'kelas' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Kelas tidak boleh kosong'
                    ]
                ],
                'divisi' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Divisi tidak boleh kosong'
                    ]
                ],
                'status_pembayaran' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Status tidak boleh kosong'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();
                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
                $idcapes = $this->request->getVar('idcapes');
                $niklama = $this->request->getVar('niklama');
                $nikbaru = $this->request->getVar('nik');

                if ($berkas = $this->berkasModel->where('nik', $niklama)->get()->getRowArray()) {
                    $idberkas = $berkas['id'];
                    $updateberkas = [
                        'nik' => $nikbaru
                    ];

                    $this->berkasModel->update($idberkas, $updateberkas);
                }

                $update = [
                    'no_reg' => $this->request->getVar('no_reg'),
                    'nik' => $nikbaru,
                    'nisn' => $this->request->getVar('nisn'),
                    'nama_lengkap' => $this->request->getVar('nama_lengkap'),
                    'email' => $this->request->getVar('email'),
                    'kelas' => $this->request->getVar('kelas'),
                    'divisi' => $this->request->getVar('divisi'),
                    'no_va' => $this->request->getVar('no_va'),
                    'status_pembayaran' => $this->request->getVar('status_pembayaran')
                ];


                $this->capesModel->update($idcapes, $update);

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Calon Peserta Didik berhasil diupdate'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function importcapes()
    {
        if ($this->request->isAJAX()) {

            $file = $this->request->getFile('filecapes');

            if ($file) {
                $excelReader  = new PHPExcel();
                //mengambil lokasi temp file
                $fileLocation = $file->getTempName();
                //baca file
                $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
                //ambil sheet active

                $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);
                // $sheet    = $objPHPExcel->getActiveSheet()->rangeToArray(null, true, true, true);

                foreach ($sheet as $idx => $data) {
                    //skip index 1 karena title excel
                    if ($idx == 1) {
                        continue;
                    }

                    // $no_reg = $data['B'];
                    $nik = $data['C'];
                    $nisn = $data['D'];
                    $nama_lengkap = $data['E'];
                    $email = $data['F'];
                    $kelas = $data['G'];
                    $divisi = $data['H'];
                    $no_va = $data['I'];
                    $status_pembayaran = $data['J'];


                    $cekcapes = $this->capesModel->where('no_va', $no_va)->countAllResults();

                    if ($cekcapes == 0) {
                        // insert data
                        $this->capesModel->insert([
                            // 'no_reg'        =>    $no_reg,
                            'nik'        =>    $nik,
                            'nisn'       =>    $nisn,
                            'nama_lengkap'       =>    $nama_lengkap,
                            'email'       =>    $email,
                            'kelas'       =>    $kelas,
                            'divisi'       =>    $divisi,
                            'no_va'       =>    $no_va,
                            'status_pembayaran'       =>    $status_pembayaran,
                        ]);
                    }
                }

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Import calon peserta didik berhasil'
                ];
            } else {
                //upload gagal
                $data = [
                    'responce' => 'error',
                    'pesan' => 'Import pegawai gagal'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function deletecapes()
    {
        if ($this->request->isAJAX()) {
            if ($id = $this->request->getVar('checkbox_value')) {
                for ($count = 0; $count < count($id); $count++) {
                    // $this->karyawanModel->delete_karyawan($id[$count]);
                    $this->capesModel->where('id', $id[$count])->delete();
                }

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Data calon peserta didik berhasil dihapus'
                ];

                echo json_encode($data);
            }
        } else {
            echo "No direct script access allowed";
        }
    }

    public function importva()
    {
        if ($this->request->isAJAX()) {

            $file = $this->request->getFile('fileva');

            if ($file) {
                $excelReader  = new PHPExcel();
                //mengambil lokasi temp file
                $fileLocation = $file->getTempName();
                //baca file
                $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
                //ambil sheet active
                $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);

                foreach ($sheet as $idx => $data) {
                    //skip index 1 karena title excel
                    if ($idx == 1) {
                        continue;
                    }

                    $no_va = $data['B'];
                    $no_reg = $data['C'];
                    $status_pembayaran = $data['F'];


                    $this->capesModel
                        ->where('no_va', $no_va)
                        ->set([
                            'no_reg' => $no_reg,
                            'status_pembayaran' => $status_pembayaran
                        ])
                        ->update();
                }

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Import calon peserta didik berhasil'
                ];
            } else {
                //upload gagal
                $data = [
                    'responce' => 'error',
                    'pesan' => 'Import pegawai gagal'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }
}
