<?php

namespace App\Controllers;

use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\TglbukaModel;
use App\Models\AlurModel;
use App\Models\JadwalModel;
use App\Models\BiayaModel;
use App\Models\BerkasModel;
use App\Models\DownloadModel;

class Home extends BaseController
{


  protected $tglBukaModel;
  protected $capesModel;
  protected $userModel;
  protected $alurModel;
  protected $jadwalModel;
  protected $biayaModel;
  protected $berkasModel;
  protected $downloadModel;


  public function __construct()
  {
    helper('fisi');
    $this->capesModel = new CapesModel();
    $this->userModel = new UserModel();
    $this->tglBukaModel = new TglbukaModel();
    $this->alurModel = new AlurModel();
    $this->jadwalModel = new JadwalModel();
    $this->biayaModel = new BiayaModel();
    $this->berkasModel = new BerkasModel();
    $this->downloadModel = new DownloadModel();
  }

  public function index()
  {

    // $tglnow = date('Y-m-d');
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();
    // dd($tglnow);
    // d($tglbuka['tglbuka']);

    $data = [
      'title' => 'Beranda PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    if ($tglnow >= $tglbuka['tglbuka']) {
      return view('home', $data);
    } else {
      return view('countdown', $data);
    }
  }

  public function peserta()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $data = [
      'title' => 'Peserta PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('peserta', $data);
  }

  public function fetchcapesfront()
  {
    if ($this->request->isAJAX()) {
      if ($capes = $this->capesModel->getStatus()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch jabatan'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function registrasi()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $data = [
      'title' => 'Registrasi PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('registrasi', $data);
  }

  public function pagelogin()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $data = [
      'title' => 'Login PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('pagelogin', $data);
  }

  public function prosedur()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $alur = $this->alurModel->where('aktif', 1)->orderBy('sort', 'ASC')->findAll();

    $data = [
      'title' => 'Prosedur PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'alur' => $alur,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('prosedur', $data);
  }

  public function jadwalppdb($divisi)
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $jadwal = $this->jadwalModel->where('divisi', $divisi)->orderBy('sort', 'ASC')->findAll();

    $data = [
      'title' => 'Prosedur PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'jadwal' => $jadwal,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('jadwalppdb', $data);
  }

  public function biayappdb()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $biaya = $this->biayaModel->where('aktif', 1)->orderBy('sort', 'ASC')->findAll();

    $data = [
      'title' => 'Prosedur PPDB MIJ',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'biaya' => $biaya,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('biaya', $data);
  }

  public function uploadberkas()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $capes = $this->capesModel->findAll();

    $data = [
      'title' => 'Upload Berkas Pendaftaran',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'capes' => $capes,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('uploadberkas', $data);
  }

  public function ceknamaupload()
  {
    if ($this->request->isAJAX()) {
      $ceknama = $this->request->getVar('ceknama');
      if ($capesnama = $this->capesModel->where('nama_lengkap', $ceknama)->get()->getRowArray()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'capesnama' => $capesnama
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch calon peserta'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function uploaddataberkas()
  {
    if ($this->request->isAJAX()) {

      if (!$this->validate([
        'nik' => [
          'rules' => 'required|is_unique[berkas.nik]',
          'errors' => [
            'required' => 'Data belum dipilih',
            'is_unique' => 'Maaf, Berkas anda sudah diupload'
          ]
        ],
        'email' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Email tidak boleh kosong'
          ]
        ],

        'fileupload' => [
          'rules' => 'uploaded[fileupload]|max_size[fileupload,30024]|ext_in[fileupload,zip,rar]',
          'errors' => [
            'uploaded' => 'file tidak boleh kosong',
            'max_size' => 'ukuran file terlalu besar. Max 30 mb ',
            'ext_in' => 'Gunakan file ekstensi zip atau rar'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses

        $nik = $this->request->getVar('nik');
        $inputemail = $this->request->getVar('email');

        $cekdata = $this->capesModel->where('nik', $nik)->get()->getRowArray();

        if ($cekdata['email'] != $inputemail) {
          $data = [
            'responce' => 'error',
            'pesan' => 'Email tidak sesuai dengan akun yang terdaftar'
          ];
        } elseif ($cekdata['status_pembayaran'] != 'sudah') {
          $data = [
            'responce' => 'error',
            'pesan' => 'Maaf anda harus melakukan pembayaran sebelum upload berkas'
          ];
        } else {
          $fileUpload = $this->request->getFile('fileupload');

          //generate nama file random
          // $namaFile = $fileUpload->getRandomName();
          $namalengkap = $this->request->getVar('namalengkap');

          $nama1 = str_replace(' ', '', $namalengkap);
          $nama2 = str_replace('.', '', $nama1);
          $nama3 = str_replace(',', '', $nama2);

          $ext = $fileUpload->getClientExtension();
          $namaFile = date('ymd') . '' . $nik . '' . $nama3 . '.' . $ext;

          //pindahkan gambar
          $fileUpload->move('asset/berkas', $namaFile);


          $insert = [
            'nik' => $this->request->getVar('nik'),
            'file' => $namaFile
          ];

          $this->berkasModel->insert($insert);

          // $this->session->setFlashdata('pesan', 'Berkas berhasil diupload.');

          $data = [
            'responce' => 'success',
            'pesan' => 'Berkas berhasil diupload'
          ];
        }
      }
      echo json_encode($data);
    } else {
      echo "No Direct Script access allowed";
    }
  }

  public function downloadberkas()
  {
    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");
    $tglbuka = $this->tglBukaModel->get()->getRowArray();

    $filedownload = $this->downloadModel->orderBy('sort', 'ASC')->findAll();

    $data = [
      'title' => 'Upload Berkas Pendaftaran',
      'tglnow' => $tglnow,
      'tglbuka' => $tglbuka,
      'filedownload' => $filedownload,
      'description' => 'Selamat datang di website Penerimaan Peserta Didik Baru (PPDB) Online Madrasah Istiqlal Jakarta. Untuk informasi lebih lanjut silahkan klik link berikut',
      'keywords' => 'ppdb,mij,madrasah,istiqlal,jakarta,penerimaan,siswa,baru'
    ];

    return view('downloadberkas', $data);
  }
}
