<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">


    <div class="row">

      <div class="col-md-12">
        <div class="row mb-2">
          <div class="col-md-4">
            <form action="">
              <div class="form-group row">
                <label for="cekva" class="col-sm-4 col-form-label">Cek Divisi</label>
                <div class="col-sm-8">
                  <select name="cekdivisi" id="cekdivisi" class="form-control">
                    <option value="semua" selected>Tampilkan semua</option>
                    <option value="kb">KB</option>
                    <option value="ra">RA</option>
                    <option value="mi">MI</option>
                    <option value="mts">MTs</option>
                    <option value="ma">MA</option>
                  </select>
                </div>
              </div>
            </form>
          </div>

        </div>

        <div class="row">
          <div class="col">
            <div class="table-responsive">
              <table class="table table-striped table-condensed" id="tabelBerkas">
                <thead class="bg-success">
                  <tr>
                    <!-- <th><input type="checkbox" id='checkall'></th> -->
                    <th scope="col">No</th>
                    <th scope="col">NIK</th>
                    <th scope="col">No Pembayaran</th>
                    <th scope="col">Nama</th>
                    <th scope="col">Divisi</th>
                    <th scope="col">Action</th>

                  </tr>
                </thead>

              </table>
            </div>
          </div>
        </div>

        <div class="overlay asal-divisi-overlay" style="display: none;">
          <!-- <i class="fas fa-sync fa-spin"></i> -->
          <div id='loading-img'></div>
        </div>



      </div>
    </div>



  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
  $(document).ready(function() {

    function tabelberkas(dataks) {
      let i = 1
      $('#tabelBerkas').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel',
            customizeData: function(data) {
              for (var i = 0; i < data.body.length; i++) {
                for (var j = 0; j < data.body[i].length; j++) {
                  if (data.header[j] == "NIK") {
                    data.body[i][j] = '\u200C' + data.body[i][j];
                  }

                  if (data.header[j] == "No Pembayaran") {
                    data.body[i][j] = '\u200C' + data.body[i][j];
                  }

                }
              }
            }
          },
          {
            extend: 'csvHtml5',
            text: '<i class="fas fa-fw fa-file-csv"></i>',
            titleAttr: 'Csv',

          }
        ],
        "columnDefs": [{
          "className": "text-center",
          "targets": "_all"
        }],

        "columns": [

          {
            "data": null,
            "render": function() {

              return a = i++;
            }
          },

          {
            "data": "nik"
          },
          {
            "data": "no_va"
          },
          {
            "data": "nama_lengkap"
          },
          {
            "data": "divisi"
          },
          {
            "data": "file",
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                                   
                                    <a href="<?= base_url(); ?>/asset/berkas/` + data + `" class="badge badge-info "><i class="fas fa-fw fa-download"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deleteberkas"><i class="fas fa-fw fa-trash"></i></a>
                                    
                                    `

              return a;
            }
          }

        ]
      });
    }


    //fetch Berkas semua
    function fetchBerkasSemua() {
      $('.asal-divisi-overlay').show();
      $.ajax({
        url: '<?= base_url(); ?>/berkas/fetchberkassemua',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data.pegawai);
          $('#tabelBerkas').DataTable().clear();
          $('#tabelBerkas').DataTable().destroy();
          tabelberkas(data.berkas)
        }
      });
      $('.asal-divisi-overlay').hide();
    }

    fetchBerkasSemua();

    $("#cekdivisi").change(function() {
      let cekdivisi = $("#cekdivisi").val();
      // alert(divisiasal)
      if (cekdivisi == 'semua') {
        fetchBerkasSemua();
      } else {
        $('.asal-divisi-overlay').show();
        $('#tabelBerkas').DataTable().clear();
        $('#tabelBerkas').DataTable().destroy();
        $.ajax({
          url: "<?= base_url(); ?>/berkas/fetchberkasdivisi",
          type: "post",
          data: {
            cekdivisi: cekdivisi
          },
          async: true,
          dataType: "json",

          success: function(data) {
            // console.log(data.satuan)
            if (data.responce == 'success') {
              // console.log(data.responce)
              tabelberkas(data.berkas)
            } else {
              // console.log(data.responce)
              tabelberkas(data.berkas)
            }
          }
        });


        $('.asal-divisi-overlay').hide();
      }
    })




    // delete berkas
    $(document).on("click", ".deleteberkas", function() {
      event.preventDefault();
      let idberkas = $(this).attr('value');

      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/berkas/deleteberkas'); ?>/' + idberkas,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {
              $('#tabelBerkas').DataTable().destroy();
              fetchBerkasSemua();
              Swal.fire(
                'Deleted!',
                'Berkas sudah terdelete.',
                'success'
              )
            }
          });

        }
      })
    });

  })
</script>

<?= $this->endSection(); ?>