<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">


        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">
                    <div class="col-md-8">
                        <button type="button" id="btntambahuser" class="btn btn-primary" data-toggle="modal" data-target="#tambahUserModal">
                            Tambah
                        </button>

                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahUserModal" tabindex="-1" aria-labelledby="tambahUserModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahUserModalLabel">Tambah Admin PPDB MIJ</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahuserform">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="username" class="col-sm-2 col-form-label">Username</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="username">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="password" class="col-sm-2 col-form-label">Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="password">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="repassword" class="col-sm-2 col-form-label">Re-Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="repassword">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nama" class="col-sm-2 col-form-label">Nama</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="nama">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="level" class="col-sm-2 col-form-label">Level</label>
                                            <div class="col-sm-10">

                                                <select name="level" id="level" class="form-control">
                                                    <option disabled selected>Tampilkan semua</option>
                                                    <option value="admin">Admin</option>
                                                    <option value="user">user</option>

                                                </select>
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editUserModalLabel">Edit Admin PPDB</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="edituserform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="iduser">
                                        <div class="form-group row">
                                            <label for="username" class="col-sm-2 col-form-label">Username</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="username">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nama" class="col-sm-2 col-form-label">Nama</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="nama">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="level" class="col-sm-2 col-form-label">Level</label>
                                            <div class="col-sm-10">

                                                <select name="level" id="editlevel" class="form-control">
                                                    <option disabled selected>Tampilkan semua</option>


                                                </select>
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Password -->
                    <div class="modal fade" id="editPasswordModal" tabindex="-1" aria-labelledby="editPasswordModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editPasswordModalLabel">Edit Password</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editpasswordform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="iduser">
                                        <div class="form-group row">
                                            <label for="password" class="col-sm-2 col-form-label">Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="password">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="repassword" class="col-sm-2 col-form-label">Re-Password</label>
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="repassword">
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>



                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelUser">
                                <thead class="bg-success">
                                    <tr>
                                        <!-- <th><input type="checkbox" id='checkall'></th> -->
                                        <th scope="col">No</th>
                                        <th scope="col">Username</th>
                                        <th scope="col">Nama Lengkap</th>
                                        <th scope="col">Level</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
    $(document).ready(function() {

        function tabeluser(dataks) {
            let i = 1;
            $('#tabelUser').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "username"
                    },
                    {
                        "data": "nama"
                    },
                    {
                        "data": "level"
                    },
                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                    <a href="" value="${row.id}" class="badge badge-warning editpassword"><i class="fas fa-fw fa-lock"></i></a>

                                    <a href="" value="${row.id}" class="badge badge-info edituser"><i class="fas fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deleteuser"><i class="fas fa-fw fa-trash"></i></a>

                                    `

                            return a;
                        }
                    },
                ]
            });
        }



        //fetch User semua
        function fetchUser() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/user/fetchuser',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    // let i = 1;
                    tabeluser(data.user)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchUser();


        $(document).on('click', '#btntambahuser', function() {
            $('#tambahuserform')[0].reset();
        })

        $(document).on('click', '.editpassword', function() {
            $('#editpasswordform')[0].reset();
        })

        // save capes
        $('#tambahuserform').submit(function() {
            event.preventDefault();

            $.ajax({
                url: '<?= base_url('/user/saveuser'); ?>',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                // data: $(this).serialize(),

                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahUserModal').modal('hide');
                        $('#tabelUser').DataTable().clear();
                        $('#tabelUser').DataTable().destroy();
                        fetchUser();
                        toastr["success"](data.pesan);

                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },

            });

        });

        // modal edit
        $(document).on("click", ".edituser", function() {
            event.preventDefault();
            $("#editlevel").children().remove();
            let iduser = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/user/editmodal'); ?>',
                type: 'post',
                data: {
                    iduser: iduser
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        $('#editUserModal').modal('show');
                        $("input[name='iduser']").val(data.user.id);
                        $("input[name='username']").val(data.user.username);
                        $("input[name='nama']").val(data.user.nama);

                        $("#editlevel").append('<option value="admin"' + ((data.user.level == 'admin') ? 'selected="selected"' : '') + '>Admin</option>');
                        $("#editlevel").append('<option value="user"' + ((data.user.level == 'user') ? 'selected="selected"' : '') + '>User</option>');


                    } else {

                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        // edit user
        $("#edituserform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/user/edituser',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editUserModal').modal('hide');
                        $('#tabelUser').DataTable().destroy();
                        fetchUser();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                }

            });
        })


        $(document).on('click', '.editpassword', function(e) {
            e.preventDefault()

            let iduser = $(this).attr("value");

            $('#editPasswordModal').modal('show')
            $("input[name='iduser']").val(iduser);
        });

        // edit password
        $("#editpasswordform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/user/editpassword',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editPasswordModal').modal('hide');
                        $('#tabelUser').DataTable().clear();
                        $('#tabelUser').DataTable().destroy();
                        fetchUser();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                }

            });
        })

        // delete user
        $(document).on("click", ".deleteuser", function() {
            event.preventDefault();
            let iduser = $(this).attr('value');

            Swal.fire({
                title: 'Apa kamu yakin untuk menghapusnya?',
                text: "kamu tidak akan bisa mengembalikannya",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus saja!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?= base_url('/user/deleteuser'); ?>/' + iduser,
                        type: 'DELETE',
                        error: function() {
                            alert('Something is wrong');
                        },
                        success: function(data) {
                            $('#tabelUser').DataTable().destroy();
                            fetchUser();
                            Swal.fire(
                                'Deleted!',
                                'User sudah terdelete.',
                                'success'
                            )
                        }
                    });

                }
            })
        });



    })
</script>

<?= $this->endSection(); ?>