<?php

namespace App\Models;

use CodeIgniter\Model;

class BerkasModel extends Model
{
    protected $table      = 'berkas';
    protected $allowedFields = ['nik', 'file'];

    // protected $useTimestamps = true;
    // protected $createdField  = 'created_at';
    // protected $updatedField  = 'updated_at';

    // protected $primaryKey = 'id';

    // protected $returnType     = 'array';
    // protected $useSoftDeletes = true;


    // protected $deletedField  = 'deleted_at';

    // protected $validationRules    = [];
    // protected $validationMessages = [];
    // protected $skipValidation     = false;

    public function getBerkas()
    {
        $builder = $this->db->table($this->table);
        $builder->select('berkas.*,capes.no_va,capes.nama_lengkap,capes.divisi');
        $builder->join('capes', 'capes.nik = berkas.nik');
        $query = $builder->get()->getResultArray();

        return $query;
    }

    public function getBerkasDivisi($divisi)
    {
        $builder = $this->db->table($this->table);
        $builder->select('berkas.*,capes.no_va,capes.nama_lengkap,capes.divisi');
        $builder->join('capes', 'capes.nik = berkas.nik');
        $builder->where('divisi', $divisi);
        $query = $builder->get()->getResultArray();

        return $query;
    }
}
