<?php

namespace App\Controllers\backend;

use PHPExcel;
use PHPExcel_IOFactory;
use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\BerkasModel;
use App\Models\KelasModel;
use CodeIgniter\Controller;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// use PHPMailer;
// use SMTP;
// use Exception;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;


class Capes extends Controller
{

  protected $loginModel;
  protected $capesModel;
  protected $berkasModel;
  protected $kelasModel;


  public function __construct()
  {
    helper('fisi');
    $this->loginModel = new LoginModel();
    $this->capesModel = new CapesModel();
    $this->berkasModel = new BerkasModel();
    $this->kelasModel = new KelasModel();
  }

  public function index()
  {

    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

    // dd($submenu);

    $data = [
      'title' => 'Calon Peserta Didik',
      'user' => $cekuser,

    ];

    return view('backend/capes', $data);
  }

  public function fetchcapessemua()
  {
    if ($this->request->isAJAX()) {
      if ($capes = $this->capesModel->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch jabatan'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function fetchcapesbelum()
  {
    if ($this->request->isAJAX()) {
      if ($capes = $this->capesModel->where('status_pembayaran', 'belum')->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch jabatan'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function fetchcapessudah()
  {
    if ($this->request->isAJAX()) {
      if ($capes = $this->capesModel->where('status_pembayaran', 'sudah')->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch jabatan'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function savecapes()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([

        'nik' => [
          'rules' => 'required|is_unique[capes.nik]|exact_length[16] ',
          'errors' => [
            'required' => 'NIK tidak boleh kosong',
            'is_unique' => 'NIK sudah didaftarkan',
            'exact_length' => "NIK Harus 16 Digit"
          ]
        ],
        'nama_lengkap' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama tidak boleh kosong'
          ]
        ],
        'namaortu' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama Orangtua tidak boleh kosong'
          ]
        ],
        'tgllahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tanggal Lahir tidak boleh kosong'
          ]
        ],
        'sekolahasal' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Sekolah Asal tidak boleh kosong'
          ]
        ],
        'j_kel' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Jenis Kelamin tidak boleh kosong'
          ]
        ],
        'email' => [
          'rules' => 'required|valid_email',
          'errors' => [
            'required' => 'Email tidak boleh kosong',
            'valid_email' => 'Email tidak valid'
          ]
        ],
        'saudarakandung' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Punya saudara di MIJ tidak boleh kosong'
          ]
        ],
        'anakke' => [
          'rules' => 'required|integer',
          'errors' => [
            'required' => 'Anak Ke- tidak boleh kosong',
            'integer' => 'Anak Ke- harus angka'
          ]
        ],
        'jumlahsaudara' => [
          'rules' => 'required|integer',
          'errors' => [
            'required' => 'Jumlah bersaudara tidak boleh kosong',
            'integer' => 'Jumlah Saudara harus angka'
          ]
        ],
        'kelas' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Kelas tidak boleh kosong'
          ]
        ],
        'divisi' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Divisi tidak boleh kosong'
          ]
        ],
        'nohp' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nomor HP tidak boleh kosong'
          ]
        ],

      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses

        $divisi = $this->request->getVar('divisi');
        $kelas = $this->request->getVar('kelas');
        $nik = $this->request->getVar('nik');
        $nama_lengkap = $this->request->getVar('nama_lengkap');
        $nama_ortu = $this->request->getVar('namaortu');
        $tgl_lahir = $this->request->getVar('tgllahir');
        $usia = $this->request->getVar('usia');
        $sekolah_asal = $this->request->getVar('sekolahasal');
        $j_kel = $this->request->getVar('j_kel');
        $no_hp = $this->request->getVar('nohp');
        $email = $this->request->getVar('email');
        $infoppdb = $this->request->getVar('infoppdb');
        $saudara_kandung = $this->request->getVar('saudarakandung');
        $anak_ke = $this->request->getVar('anakke');
        $jumlah_saudara = $this->request->getVar('jumlahsaudara');


        $no_reg = strtoupper($divisi) . "" . substr(date('y'), -2) . "" . date('m') . "" . date('d') . "" . substr($nik, -4);


        $insert = [
          'divisi' => $divisi,
          'kelas' => $kelas,
          'nik' => $nik,
          'nama_lengkap' => $nama_lengkap,
          'nama_ortu' => $nama_ortu,
          'tgl_lahir' => $tgl_lahir,
          'usia' => $usia,
          'sekolah_asal' => $sekolah_asal,
          'j_kel' => $j_kel,
          'no_hp' => $no_hp,
          'email' => $email,
          'infoppdb' => $infoppdb,
          'no_reg' => $no_reg,
          'saudara_kandung' => $saudara_kandung,
          'anak_ke' => $anak_ke,
          'jumlah_saudara' => $jumlah_saudara,

          'status_pembayaran' => 'belum'
        ];


        $this->capesModel->insert($insert);


        $mail = new PHPMailer(true);

        try {

          // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
          $mail->isSMTP();
          // $mail->SMTPDebug  = 0;

          // $mail->SMTPDebug  = 2;
          // $mail->Debugoutput = 'html';

          $mail->Host       = 'smtp.gmail.com';
          $mail->SMTPAuth   = true;
          $mail->SMTPSecure = 'ssl';
          $mail->Port       = 465;
          //$mail->Port       = 25;

          $mail->Username   = "ppdbistiqlal@mij.sch.id"; // silahkan ganti dengan alamat email Anda
          $mail->Password   = "lbnixwrwxxzjapmu"; // silahkan ganti dengan password email Anda

          $mail->setFrom("ppdbistiqlal@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
          $mail->addAddress($email);
          $mail->addReplyTo("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
          $mail->addCC("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
          // Content
          $mail->isHTML(true);
          $mail->Subject = "Pendaftaran calon peserta didik " . $nama_lengkap . " dengan nomor registrasi" . $no_reg;


          $bodyContent = '<h1>Terima kasih sudah mendaftar menjadi Calon Peserta Didik Madrasah Istiqlal dengan nomor registrasi</h1>';
          $bodyContent = '<h1>No.Reg ' . $no_reg . '</h1>';
          $bodyContent .= '<p>Berikut informasi data calon peserta didik</p>';
          $bodyContent .= '
          
          <table border="0">
          
            <tr>
            <td>Satuan Pendidikan</td>
            <td>:</td>
            <td>' . strtoupper($divisi) . '</td>
            </tr>
            <tr>
            <td>Kelas</td>
            <td>:</td>
            <td>' . $kelas . '</td>
            </tr>
            <tr>
            <td>NIK</td>
              <td>:</td>
              <td>' . $nik . '</td>
              </tr>
              <tr>
              <td>Nama Lengkap</td>
              <td>:</td>
              <td>' . $nama_lengkap . '</td>
              </tr>
              <tr>
              <td>Nama Orangtua</td>
              <td>:</td>
              <td>' . $nama_ortu . '</td>
              </tr>
              <tr>
              <td>Tanggal lahir</td>
              <td>:</td>
              <td>' . $tgl_lahir . '</td>
              </tr>
              <tr>
              <td>Sekolah Asal</td>
              <td>:</td>
              <td>' . $sekolah_asal . '</td>
              </tr>
              <tr>
              <td>Jenis Kelamin</td>
              <td>:</td>
              <td>' . $j_kel . '</td>
              </tr>
              <tr>
              <td>No.HP</td>
              <td>:</td>
              <td>' . $no_hp . '</td>
              </tr>
              <tr>
              <td>Email</td>
              <td>:</td>
              <td>' . $email . '</td>
              </tr>
              <tr>
              <td>Anak Ke</td>
              <td>:</td>
              <td>' . $anak_ke . '</td>
              </tr>
              <tr>
              <td>Jumlah Bersaudara</td>
              <td>:</td>
              <td>' . $jumlah_saudara . '</td>
              </tr>
              
              
              </table>';

          $bodyContent .= '<h3>Jika Ada pertanyaan bisa menghubungi Hotline Humas di No. <a href="tel:08111264720"> 08111264720 (Hotline)</a></h3>';

          $mail->Body    = $bodyContent;

          $mail->send();

          $pesanemail = "sukses";
        } catch (Exception $e) {
          $pesanemail = $mail->ErrorInfo;
        }


        $data = [
          'responce' => 'success',
          'no_reg' => $no_reg,
          'pesan' => 'Calon Peserta Didik berhasil ditambah',
          'pesanemail' => $pesanemail
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }


  public function editmodal()
  {
    if ($this->request->isAJAX()) {
      $idcapes = $this->request->getVar('idcapes');
      if ($capes = $this->capesModel->where('id', $idcapes)->get()->getRowArray()) {
        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal memunculkan modal edit data'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editcapes()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([

        'nik' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'NIK tidak boleh kosong',
            'exact_length' => "NIK Harus 16 Digit"
          ]
        ],

        'nama_lengkap' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama tidak boleh kosong'
          ]
        ],
        'nama_ortu' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama Orang Tua tidak boleh kosong'
          ]
        ],
        'tgllahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tanggal Lahir tidak boleh kosong'
          ]
        ],
        'sekolahasal' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Sekolah asal tidak boleh kosong'
          ]
        ],

        'nohp' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nomor HP tidak boleh kosong'
          ]
        ],
        'email' => [
          'rules' => 'required|valid_email',
          'errors' => [
            'required' => 'Email tidak boleh kosong',
            'valid_email' => 'Email tidak valid'
          ]
        ],
        'saudarakandung' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Punya saudara di MIJ tidak boleh kosong'
          ]
        ],
        'anakke' => [
          'rules' => 'required|integer',
          'errors' => [
            'required' => 'Anak Ke- tidak boleh kosong',
            'integer' => 'Anak Ke- harus angka'
          ]
        ],
        'jumlahsaudara' => [
          'rules' => 'required|integer',
          'errors' => [
            'required' => 'Jumlah bersaudara tidak boleh kosong',
            'integer' => 'Jumlah Saudara harus angka'
          ]
        ],

        'kelas' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Kelas tidak boleh kosong'
          ]
        ],
        'divisi' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Divisi tidak boleh kosong'
          ]
        ],
        'status_pembayaran' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Status tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();
        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $idcapes = $this->request->getVar('idcapes');
        $niklama = $this->request->getVar('niklama');
        $nikbaru = $this->request->getVar('nik');
        $nama_lengkap = $this->request->getVar('nama_lengkap');
        $no_reg = $this->request->getVar('no_reg');
        $kirimemailoption = $this->request->getVar('kirimemailoption');

        $email = $this->request->getVar('email');
        $novalama = $this->request->getVar('no_va_lama');
        $novabaru = $this->request->getVar('no_va');

        $divisi = strtolower($this->request->getVar('divisi'));

        $status_pembayaran = $this->request->getVar('status_pembayaran');
        $status_pembayaran_lama = $this->request->getVar('status_pembayaran_lama');


        if ($berkas = $this->berkasModel->where('nik', $niklama)->get()->getRowArray()) {
          $idberkas = $berkas['id'];
          $updateberkas = [
            'nik' => $nikbaru
          ];

          $this->berkasModel->update($idberkas, $updateberkas);
        }

        $update = [
          // 'no_reg' => $this->request->getVar('no_reg'),
          'nik' => $nikbaru,
          // 'nisn' => $this->request->getVar('nisn'),
          'nama_lengkap' => $nama_lengkap,
          'nama_ortu' => $this->request->getVar('nama_ortu'),
          'tgl_lahir' => $this->request->getVar('tgllahir'),
          'usia' => $this->request->getVar('usia'),
          'sekolah_asal' => $this->request->getVar('sekolahasal'),
          'j_kel' => $this->request->getVar('j_kel'),
          'no_hp' => $this->request->getVar('nohp'),
          'saudara_kandung' => $this->request->getVar('saudarakandung'),
          'anak_ke' => $this->request->getVar('anakke'),
          'jumlah_saudara' => $this->request->getVar('jumlahsaudara'),
          'email' => $email,
          // 'kelas' => $this->request->getVar('kelas'),
          'divisi' => $divisi,
          'no_va' => $novabaru,
          'status_pembayaran' => $status_pembayaran
        ];


        $this->capesModel->update($idcapes, $update);


        // kirim email VA
        $mail = new PHPMailer(true);

        if ($kirimemailoption == "emailva") {

          // cek no VA lama dan no va baru
          if ($novabaru != "" && $novabaru != $novalama) {

            try {
              // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
              $mail->isSMTP();
              // $mail->SMTPDebug  = 0;

              // $mail->SMTPDebug  = 2;
              // $mail->Debugoutput = 'html';

              $mail->Host       = 'smtp.gmail.com';
              $mail->SMTPAuth   = true;
              $mail->SMTPSecure = 'ssl';
              $mail->Port       = 465;
              //$mail->Port       = 25;

              $mail->Username   = "ppdbistiqlal@mij.sch.id"; // silahkan ganti dengan alamat email Anda
              $mail->Password   = "lbnixwrwxxzjapmu"; // silahkan ganti dengan password email Anda

              $mail->setFrom("ppdbistiqlal@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addAddress($email);
              $mail->addReplyTo("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addCC("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              // Content
              $mail->isHTML(true);
              $mail->Subject = "Update No.Pembayaran calon peserta didik " . $nama_lengkap . " dengan nomor registrasi " . $no_reg;

              $bodyContent = '<h1>Terima kasih sudah sabar menunggu Nomor Pembayaran anda</h1>';
              $bodyContent .= '<h1>No.Pembayaran Anda adalah ' . $novabaru . '</h1>';
              $bodyContent .= '<p>Harap untuk segera melakukan proses pembayaran untuk melanjutkan proses berikutnya. Jika ada yang tidak dimengerti, bisa menghubungi hotline humas MIJ di No. <a href="tel:08111264720"> 08111264720 (Hotline).</p><br><br><p>Syukron Katsiron</p>';



              $mail->Body    = $bodyContent;

              $mail->send();

              $pesanemail = "success";
            } catch (Exception $e) {
              $pesanemail = $mail->ErrorInfo;
            }
          } else {
            $pesanemail = "tidak kirim email";
          }
        } elseif ($kirimemailoption == "emailstatus") {
          // cek status pembayaran
          if ($novabaru != "" && $status_pembayaran == 'sudah' && $status_pembayaran_lama == "belum") {

            // link gform satuan
            if ($divisi == "kb") {
              $link = "https://docs.google.com/forms/d/e/1FAIpQLScHIcHWx-9zDw16selfbMT98y9zpuzaaxa7Dy2SeP8EjcL_uA/viewform?usp=sf_link";
              $formsatuan = "KB";
            } elseif ($divisi == 'ra') {
              $link = "https://forms.gle/qcnBWCKwFk89CiCx8";
              $formsatuan = "RA";
            } elseif ($divisi == "mi") {
              $link = "https://forms.gle/akLnBEtBgCbuXdYU9";
              $formsatuan = "MI";
            } elseif ($divisi == "mts") {
              $link = "https://forms.gle/vxYi73pfEVooWzGF8";
              $formsatuan = "MTs";
            } elseif ($divisi == "ma") {
              $link = "https://forms.gle/YbbA68DRZKUwqosU6";
              $formsatuan = "MA";
            } else {
              $link = "google.com";
            }

            $linkdokumen = "https://docs.google.com/spreadsheets/d/1Hq57httfMNd_hbRJ17gxG_djidXVZG1tHP2eBJMTxFE/edit?usp=sharing";

            try {
              // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
              $mail->isSMTP();
              // $mail->SMTPDebug  = 0;

              // $mail->SMTPDebug  = 2;
              // $mail->Debugoutput = 'html';

              $mail->Host       = 'smtp.gmail.com';
              $mail->SMTPAuth   = true;
              $mail->SMTPSecure = 'ssl';
              $mail->Port       = 465;
              //$mail->Port       = 25;

              $mail->Username   = "ppdbistiqlal@mij.sch.id"; // silahkan ganti dengan alamat email Anda
              $mail->Password   = "lbnixwrwxxzjapmu"; // silahkan ganti dengan password email Anda

              $mail->setFrom("ppdbistiqlal@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addAddress($email);
              $mail->addReplyTo("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addCC("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              // Content
              $mail->isHTML(true);
              $mail->Subject = "Update Status Pembayaran calon peserta didik " . $nama_lengkap . " dengan nomor registrasi" . $no_reg;

              $bodyContent = '<h1>Terima kasih sudah melakukan proses pembayaran</h1>';
              // $bodyContent .= '<p>Silahkan siapkan dokumen sesuai attachment email ini dan mengisi formulir dengan mengklik link di bawah ini atau bisa dicek di halaman peserta->Cek status peserta</p>';
              $bodyContent .= '<h2>Silahkan klik link ini untuk melihat syarat upload dokumen <a href="' . $linkdokumen . '">Syarat Upload Dokumen</a></h2>';
              $bodyContent .= '<h2>Jika sudah menyiapkan dokumennya, silahkan <a href="' . $link . '">Isi Form Tahap 2 ' . $formsatuan . '</a> sebagai tahap terakhir sebelum menunggu info seleksi siswa dari Hotline Humas MIJ</h2>';

              $bodyContent .= '<h3>Jika Ada pertanyaan bisa menghubungi Hotline Humas di No. <a href="tel:08111264720"> 08111264720 (Hotline)</a></h3>';


              $mail->Body    = $bodyContent;
              // $mail->AddAttachment(base_url('/asset/template/syarat_upload_dokumen.pdf'), "Syarat Upload Dokumen");

              $mail->send();

              $pesanemail = "success";
            } catch (Exception $e) {
              $pesanemail = $mail->ErrorInfo;
            }
          } else {
            $pesanemail = "tidak kirim email";
          }
        } else {
          $pesanemail = "tidak kirim email";
        }


        $data = [
          'responce' => 'success',
          'pesan' => 'Calon Peserta Didik berhasil diupdate',
          'pesanemail' => $pesanemail
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }


  public function importva()
  {
    if ($this->request->isAJAX()) {

      $file = $this->request->getFile('fileva');


      if ($file) {

        $ext = $file->getClientExtension();

        if ($ext == 'xls') {
          $render = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        } else {
          $render = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        }

        $spreadsheet = $render->load($file);

        // $data = $spreadsheet->getActiveSheet()->toArray();
        $data = $spreadsheet->getActiveSheet()->toArray("", true, true, true);
        // $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);

        $angkakosong = 0;
        // $ceknip = array();
        $barisgagal = array();

        foreach ($data as $cekidx => $cekdata) {
          //skip index 1 karena title excel
          if ($cekidx == 1) {
            continue;
          }

          $creg = $cekdata['B'];
          // array_push($ceknip, $cnip);

          if ($this->capesModel->where('no_reg', $creg)->countAllResults() == 0) {
            $angkakosong++;
            array_push($barisgagal, $cekidx);
          }
        }

        if ($angkakosong > 0) {
          //upload gagal
          $data = [
            'responce' => 'errorkosong',
            'pesan' => 'Update VA gagal',
            'barisgagal' => $barisgagal
          ];
        } else {
          foreach ($data as $idx => $data) {
            //skip index 1 karena title excel

            if ($idx == 1) {
              continue;
            }

            $no_reg = $data['B'];
            $nik = $data['C'];
            $nama_lengkap = $data['D'];
            $kelas = $data['E'];
            $divisi = $data['F'];
            $no_va = $data['G'];
            $status_pembayaran = $data['H'];

            $capesupdate = $this->capesModel->where('no_reg', $no_reg)->get()->getRowArray();
            $email = $capesupdate['email'];

            $this->capesModel
              ->where('no_reg', $no_reg)
              ->set([
                'no_va' => $no_va,
                'status_pembayaran' => $status_pembayaran
              ])
              ->update();

            $mail = new PHPMailer(true);

            try {

              // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
              $mail->isSMTP();
              // $mail->SMTPDebug  = 0;

              // $mail->SMTPDebug  = 2;
              // $mail->Debugoutput = 'html';

              $mail->Host       = 'smtp.gmail.com';
              $mail->SMTPAuth   = true;
              $mail->SMTPSecure = 'ssl';
              $mail->Port       = 465;
              //$mail->Port       = 25;

              $mail->Username   = "ppdbistiqlal@mij.sch.id"; // silahkan ganti dengan alamat email Anda
              $mail->Password   = "lbnixwrwxxzjapmu"; // silahkan ganti dengan password email Anda

              $mail->setFrom("ppdbistiqlal@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addAddress($email);
              $mail->addReplyTo("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addCC("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              // Content
              $mail->isHTML(true);
              $mail->Subject = "Update No.Pembayaran calon peserta didik " . $nama_lengkap . " dengan nomor registrasi" . $no_reg;

              $bodyContent = '<h1>Terima kasih sudah sabar menunggu Nomor Pembayaran anda</h1>';
              $bodyContent .= '<h1>No.Pembayaran Anda adalah ' . $no_va . '</h1>';
              $bodyContent .= '<p>Harap untuk segera melakukan proses pembayaran untuk melanjutkan proses berikutnya. Jika ada yang tidak dimengerti, bisa menghubungi hotline humas MIJ di No. <a href="tel:08111264720"> 08111264720 (Hotline)</a>.</p><br><br><p>Syukron Katsiron</p>';


              $mail->Body    = $bodyContent;

              $mail->send();

              $pesanemail = "sukses";
            } catch (Exception $e) {
              $pesanemail = $mail->ErrorInfo;
            }
          }

          $data = [
            'responce' => 'success',
            'pesan' => 'Import nomor pembayaran berhasil',
            'pesanemail' => $pesanemail
          ];
        }
      } else {
        //upload gagal
        $data = [
          'responce' => 'error',
          'pesan' => 'Import nomor pembayaran gagal'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }


  public function importstatus()
  {
    if ($this->request->isAJAX()) {

      $file = $this->request->getFile('filestatus');

      if ($file) {

        $ext = $file->getClientExtension();

        if ($ext == 'xls') {
          $render = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        } else {
          $render = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        }

        $spreadsheet = $render->load($file);

        // $data = $spreadsheet->getActiveSheet()->toArray();
        $data = $spreadsheet->getActiveSheet()->toArray("", true, true, true);
        // $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);



        $angkakosong = 0;
        // $ceknip = array();
        $barisgagal = array();

        foreach ($data as $cekidx => $cekdata) {
          //skip index 1 karena title excel
          if ($cekidx == 1) {
            continue;
          }

          $cnova = $cekdata['B'];
          // array_push($ceknip, $cnip);

          if ($this->capesModel->where('no_va', $cnova)->countAllResults() == 0) {
            $angkakosong++;
            array_push($barisgagal, $cekidx);
          }
        }

        if ($angkakosong > 0) {
          //upload gagal
          $data = [
            'responce' => 'errorkosong',
            'pesan' => 'Update Status gagal',
            'barisgagal' => $barisgagal
          ];
        } else {
          foreach ($data as $idx => $data) {
            //skip index 1 karena title excel
            if ($idx == 1) {
              continue;
            }

            $no_va = $data['B'];
            $no_reg = $data['C'];
            $nik = $data['D'];

            $nama_lengkap = $data['E'];
            $status_pembayaran = $data['H'];

            $capesupdate = $this->capesModel->where('no_va', $no_va)->get()->getRowArray();
            $email = $capesupdate['email'];
            $divisi = $capesupdate['divisi'];

            $this->capesModel
              ->where('no_va', $no_va)
              ->set([
                'status_pembayaran' => $status_pembayaran
              ])
              ->update();


            // link gform satuan
            if ($divisi == "kb") {
              $link = "https://docs.google.com/forms/d/e/1FAIpQLScHIcHWx-9zDw16selfbMT98y9zpuzaaxa7Dy2SeP8EjcL_uA/viewform?usp=sf_link";
              $formsatuan = "KB";
            } elseif ($divisi == 'ra') {
              $link = "https://forms.gle/qcnBWCKwFk89CiCx8";
              $formsatuan = "RA";
            } elseif ($divisi == "mi") {
              $link = "https://forms.gle/akLnBEtBgCbuXdYU9";
              $formsatuan = "MI";
            } elseif ($divisi == "mts") {
              $link = "https://forms.gle/vxYi73pfEVooWzGF8";
              $formsatuan = "MTs";
            } elseif ($divisi == "ma") {
              $link = "https://forms.gle/YbbA68DRZKUwqosU6";
              $formsatuan = "MA";
            } else {
              $link = "google.com";
            }

            $linkdokumen = "https://docs.google.com/spreadsheets/d/1Hq57httfMNd_hbRJ17gxG_djidXVZG1tHP2eBJMTxFE/edit?usp=sharing";

            $mail = new PHPMailer(true);

            try {

              // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
              $mail->isSMTP();
              // $mail->SMTPDebug  = 0;

              // $mail->SMTPDebug  = 2;
              // $mail->Debugoutput = 'html';

              $mail->Host       = 'smtp.gmail.com';
              $mail->SMTPAuth   = true;
              $mail->SMTPSecure = 'ssl';
              $mail->Port       = 465;
              //$mail->Port       = 25;

              $mail->Username   = "ppdbistiqlal@mij.sch.id"; // silahkan ganti dengan alamat email Anda
              $mail->Password   = "lbnixwrwxxzjapmu"; // silahkan ganti dengan password email Anda

              $mail->setFrom("ppdbistiqlal@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addAddress($email);
              $mail->addReplyTo("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              $mail->addCC("ppdb@mij.sch.id", "PPDB MIJ"); // silahkan ganti dengan alamat email Anda
              // Content
              $mail->isHTML(true);
              $mail->Subject = "Update Status Pembayaran calon peserta didik " . $nama_lengkap . " dengan nomor registrasi" . $no_reg;

              $bodyContent = '<h1>Terima kasih sudah melakukan proses pembayaran</h1>';
              // $bodyContent .= '<p>Silahkan siapkan dokumen sesuai attachment email ini dan mengisi formulir dengan mengklik link di bawah ini atau bisa dicek di halaman peserta->Cek status peserta</p>';
              $bodyContent .= '<h2>Silahkan klik link ini untuk melihat syarat upload dokumen <a href="' . $linkdokumen . '">Syarat Upload Dokumen</a></h2>';
              $bodyContent .= '<h2>Jika sudah menyiapkan dokumennya, silahkan <a href="' . $link . '">Isi Form Tahap 2 ' . $formsatuan . '</a> sebagai tahap terakhir sebelum menunggu info seleksi siswa dari Hotline Humas MIJ</h2>';

              $bodyContent .= '<h3>Jika Ada pertanyaan bisa menghubungi Hotline Humas di No. <a href="tel:08111264720"> 08111264720 (Hotline)</a></h3>';

              $mail->Body    = $bodyContent;
              // $mail->AddAttachment(base_url('/asset/template/syarat_upload_dokumen.pdf'), "Syarat Upload Dokumen");

              $mail->send();

              $pesanemail = "sukses";
            } catch (Exception $e) {
              $pesanemail = $mail->ErrorInfo;
            }
          }

          $data = [
            'responce' => 'success',
            'pesan' => 'Import nomor pembayaran berhasil',
            'pesanemail' => $pesanemail
          ];
        }
      } else {
        //upload gagal
        $data = [
          'responce' => 'error',
          'pesan' => 'Import nomor pembayaran gagal'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function deletecapes()
  {
    if ($this->request->isAJAX()) {
      if ($id = $this->request->getVar('checkbox_value')) {
        for ($count = 0; $count < count($id); $count++) {
          // $this->karyawanModel->delete_karyawan($id[$count]);
          $this->capesModel->where('id', $id[$count])->delete();
        }

        $data = [
          'responce' => 'success',
          'pesan' => 'Data calon peserta didik berhasil dihapus'
        ];

        echo json_encode($data);
      }
    } else {
      echo "No direct script access allowed";
    }
  }

  public function importpembayaran()
  {
    if ($this->request->isAJAX()) {

      $file = $this->request->getFile('fileva');

      if ($file) {
        $excelReader  = new PHPExcel();
        //mengambil lokasi temp file
        $fileLocation = $file->getTempName();
        //baca file
        $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
        //ambil sheet active
        $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);

        foreach ($sheet as $idx => $data) {
          //skip index 1 karena title excel
          if ($idx == 1) {
            continue;
          }

          $no_va = $data['B'];
          $no_reg = $data['C'];
          $status_pembayaran = $data['F'];


          $this->capesModel
            ->where('no_va', $no_va)
            ->set([
              'no_reg' => $no_reg,
              'status_pembayaran' => $status_pembayaran
            ])
            ->update();
        }

        $data = [
          'responce' => 'success',
          'pesan' => 'Import calon peserta didik berhasil'
        ];
      } else {
        //upload gagal
        $data = [
          'responce' => 'error',
          'pesan' => 'Import pegawai gagal'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }



  public function tampilkelas()
  {
    if ($this->request->isAJAX()) {
      $divisi = $this->request->getVar('satdik');
      if ($kelas = $this->kelasModel->where('divisi', $divisi)->where('aktif', 1)->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'kelas' => $kelas
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch kelas'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function cekstatuscapes()
  {
    if ($this->request->isAJAX()) {
      $nik = $this->request->getVar('nik');
      if ($capes = $this->capesModel->where('nik', $nik)->get()->getRowArray()) {
        // dd($statuspegawai);

        // tahap 1 tunggu va
        // tahap 2 dapat va
        // tahap 3 pembayaran
        // tahap 4 status updtae
        if ($capes['no_va'] != "") {
          $nova = 'yes';
        }

        $data = [
          'responce' => 'success',
          'capes' => $capes
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch Status'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }
}
