<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">


        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">


                    <div class="col-md-4">
                        <form action="">
                            <div class="form-group row">
                                <label for="cekva" class="col-sm-4 col-form-label">Cek Divisi</label>
                                <div class="col-sm-8">
                                    <select name="cekdivisi" id="cekdivisi" class="form-control">
                                        <option value="semua" selected>Tampilkan semua</option>
                                        <option value="kb">KB</option>
                                        <option value="ra">RA</option>
                                        <option value="mi">MI</option>
                                        <option value="mts">MTs</option>
                                        <option value="ma">MA</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="col-md-8">
                        <button type="button" id="btntambahjadwal" class="btn btn-primary" data-toggle="modal" data-target="#tambahJadwalModal">
                            Tambah
                        </button>

                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahJadwalModal" tabindex="-1" aria-labelledby="tambahJadwalModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahJadwalModalLabel">Tambah Jadwal</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahjadwalform">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="tanggal" class="col-sm-2 col-form-label">Tanggal</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="tanggal">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="keterangan" class="col-sm-2 col-form-label">Keterangan</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="textbox" class="form-control"> -->
                                                <textarea class="form-control" name="keterangan" rows="3"></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nisn" class="col-sm-2 col-form-label">Divisi</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="text" class="form-control" name="nisn"> -->
                                                <select name="divisi" id="divisi" class="form-control">
                                                    <option selected disabled>Tampilkan semua</option>
                                                    <option value="kb">KB</option>
                                                    <option value="ra">RA</option>
                                                    <option value="mi">MI</option>
                                                    <option value="mts">MTs</option>
                                                    <option value="ma">MA</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnsimpan">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editJadwalModal" tabindex="-1" aria-labelledby="editJadwalModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editJadwalModalLabel">Edit Jadwal</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editjadwalform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="idjadwal">
                                        <div class="form-group row">
                                            <label for="tanggal" class="col-sm-2 col-form-label">Tanggal</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="tanggal">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="keterangan" class="col-sm-2 col-form-label">Keterangan</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" name="keterangan" id="editketerangan" rows="3"></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="nisn" class="col-sm-2 col-form-label">Divisi</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="text" class="form-control" name="nisn"> -->
                                                <select name="divisi" id="editdivisi" class="form-control">
                                                    <option disabled>Tampilkan semua</option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnupdate">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelJadwal">
                                <thead class="bg-success">
                                    <tr>
                                        <!-- <th><input type="checkbox" id='checkall'></th> -->
                                        <th scope="col">No</th>
                                        <th scope="col">Tanggal</th>
                                        <th scope="col">Keterangan</th>
                                        <th scope="col">Divisi</th>
                                        <th scope="col">Sort</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
    $(document).ready(function() {

        function tabeljadwal(dataks) {
            let i = 1
            $('#tabelJadwal').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "tanggal"
                    },
                    {
                        "data": "keterangan"
                    },
                    {
                        "data": "divisi"
                    },
                    {
                        "data": "sort"
                    },
                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                   
                                    <a href="" value="${row.id}" class="badge badge-info editjadwal"><i class="fas fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletejadwal"><i class="fas fa-fw fa-trash"></i></a>

                                    `

                            return a;
                        }
                    },
                ]
            });
        }


        //fetch Jadwal semua
        function fetchJadwalSemua() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/jadwal/fetchjadwalsemua',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    $('#tabelJadwal').DataTable().clear();
                    $('#tabelJadwal').DataTable().destroy();
                    tabeljadwal(data.jadwal)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchJadwalSemua();

        $("#cekdivisi").change(function() {
            let cekdivisi = $("#cekdivisi").val();
            // alert(divisiasal)
            if (cekdivisi == 'semua') {
                fetchJadwalSemua();
            } else {
                $('.asal-divisi-overlay').show();
                $('#tabelJadwal').DataTable().clear();
                $('#tabelJadwal').DataTable().destroy();
                $.ajax({
                    url: "<?= base_url(); ?>/jadwal/fetchjadwaldivisi",
                    type: "post",
                    data: {
                        cekdivisi: cekdivisi
                    },
                    async: true,
                    dataType: "json",

                    success: function(data) {
                        // console.log(data.satuan)
                        if (data.responce == 'success') {
                            // console.log(data.responce)
                            tabeljadwal(data.jadwal)
                        } else {
                            // console.log(data.responce)
                            tabeljadwal(data.jadwal)
                        }
                    }
                });


                $('.asal-divisi-overlay').hide();
            }
        })


        $(document).on('click', '#btntambahjadwal', function() {
            $('#tambahjadwalform')[0].reset();
        })
        // save jadwal
        $('#tambahjadwalform').submit(function() {
            event.preventDefault();

            $.ajax({
                url: '<?= base_url('/jadwal/savejadwal'); ?>',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                // data: $(this).serialize(),
                beforeSend: function() {
                    // setting a timeout
                    $('#btnsimpan').attr('disabled');
                    $("#btnsimpan").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahJadwalModal').modal('hide');
                        $('#tabelJadwal').DataTable().clear();
                        $('#tabelJadwal').DataTable().destroy();
                        fetchJadwalSemua();
                        toastr["success"](data.pesan);

                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btnsimpan').removeAttr('disabled');
                    $("#btnsimpan").html(`Simpan`);
                },

            });

        });

        // modal edit
        $(document).on("click", ".editjadwal", function() {
            event.preventDefault();
            $("#editdivisi").children().remove();
            $('#editjadwalform')[0].reset();
            let idjadwal = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/jadwal/editmodal'); ?>',
                type: 'post',
                data: {
                    idjadwal: idjadwal
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        $('#editJadwalModal').modal('show');
                        $("input[name='idjadwal']").val(data.jadwal.id);
                        $("input[name='tanggal']").val(data.jadwal.tanggal);
                        $("#editketerangan").text(data.jadwal.keterangan);
                        $("input[name='sort']").val(data.jadwal.sort);


                        $("#editdivisi").append('<option value="kb"' + ((data.jadwal.divisi == 'kb') ? 'selected="selected"' : '') + '>KB</option>');
                        $("#editdivisi").append('<option value="ra"' + ((data.jadwal.divisi == 'ra') ? 'selected="selected"' : '') + '>RA</option>');
                        $("#editdivisi").append('<option value="mi"' + ((data.jadwal.divisi == 'mi') ? 'selected="selected"' : '') + '>MI</option>');
                        $("#editdivisi").append('<option value="mts"' + ((data.jadwal.divisi == 'mts') ? 'selected="selected"' : '') + '>MTS</option>');
                        $("#editdivisi").append('<option value="ma"' + ((data.jadwal.divisi == 'ma') ? 'selected="selected"' : '') + '>MA</option>');


                    } else {

                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        // edit capes

        $("#editjadwalform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/jadwal/editjadwal',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    // setting a timeout
                    $('#btnedit').attr('disabled');
                    $("#btnedit").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editJadwalModal').modal('hide');
                        $('#tabelJadwal').DataTable().clear();
                        $('#tabelJadwal').DataTable().destroy();
                        fetchJadwalSemua();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btnedit').removeAttr('disabled');
                    $("#btnedit").html(`Update`);

                },

            });
        })

        // delete jadwal
        $(document).on("click", ".deletejadwal", function() {
            event.preventDefault();
            let idjadwal = $(this).attr('value');

            Swal.fire({
                title: 'Apa kamu yakin untuk menghapusnya?',
                text: "kamu tidak akan bisa mengembalikannya",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus saja!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?= base_url('/jadwal/deletejadwal'); ?>/' + idjadwal,
                        type: 'DELETE',
                        error: function() {
                            alert('Something is wrong');
                        },
                        success: function(data) {
                            $('#tabelJadwal').DataTable().destroy();
                            fetchJadwalSemua();
                            Swal.fire(
                                'Deleted!',
                                'File sudah terdelete.',
                                'success'
                            )
                        }
                    });

                }
            })
        });

    })
</script>

<?= $this->endSection(); ?>