<?= $this->extend('backend/layout/template_admin'); ?>


<?= $this->section('content'); ?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
      <div class="breadcrumb-title pe-3">Peserta Didik</div>
      <div class="ps-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0 p-0">
            <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page"><?= $title; ?></li>
          </ol>
        </nav>
      </div>

    </div>
    <!--end breadcrumb-->
    <h6 class="mb-0 text-uppercase"><?= $title; ?></h6>
    <hr />


    <div class="row">
      <div class="col">
        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary" id="btntambahsiswa" data-bs-toggle="modal" data-bs-target="#tambahsiswa">Tambah</button>
        <!-- Modal -->
        <div class="modal fade" id="tambahsiswa" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Tambah Siswa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form method="post" action="" id="tambahsiswaform" enctype="multipart/form-data">
                  <?= csrf_field(); ?>
                  <div class="row mb-3">
                    <label for="username" class="col-sm-3 col-form-label">Username</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="username" name="username" placeholder="Masukkan Username">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="password" class="col-sm-3 col-form-label">Password</label>
                    <div class="col-sm-9">
                      <input type="password" class="form-control" id="password" name="password" placeholder="Masukkan Password">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="repassword" class="col-sm-3 col-form-label">Re-Password</label>
                    <div class="col-sm-9">
                      <input type="password" class="form-control" id="repassword" name="repassword" placeholder="Confirm password">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <label for="no.induk" class="col-sm-3 col-form-label">No. Induk</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="no_induk" name="no_induk" placeholder="Masukkan No. Induk">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <label for="nama" class="col-sm-3 col-form-label">Nama</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="nama" name="nama" placeholder="Masukkan Nama">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="kelas" class="col-sm-3 col-form-label">Kelas</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="kelas" name="kelas" placeholder="Masukkan Kelas">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="tempat_lahir" class="col-sm-3 col-form-label">Tempat lahir</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" placeholder="Masukkan Tempat lahir">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="tgl_lahir" class="col-sm-3 col-form-label">Tgl lahir</label>
                    <div class="col-sm-9">
                      <input type="date" class="form-control" id="tgl_lahir" name="tgl_lahir" placeholder="Masukkan Tgl lahir">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="nisn" class="col-sm-3 col-form-label">NISN</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="nisn" name="nisn" placeholder="Masukkan NISN">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9">

                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="cekskl" id="cekskl">
                        <label class="form-check-label" for="cekskl">Ada SKL-nya?</label>
                      </div>
                    </div>
                  </div>
                  <div class="row mb-3" id="formutkjudul">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9">
                      <p>Penulisan judul file SKL harus dengan ekstensi pdf agar bisa diupload massal di menu media. Contoh <b>skl1.pdf</b></p>
                    </div>
                    <label for="judulskl" class="col-sm-3 col-form-label">Judul File SKL</label>
                    <div class="col-sm-9">
                      <!-- <input type="text" class="form-control" id="judulbuku" name="judulbuku" placeholder="Masukkan Judul File Buku"> -->
                      <textarea class="form-control" id="judulskl" name="judulskl" placeholder="Masukkan Judul File SKL" rows="2"></textarea>
                    </div>
                  </div>
                  <div class="row mb-3" hidden id="formutkskl">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9">

                      <p>Format file harus berekstensi PDF agar tidak error saat dibacanya. Contoh <b>buku1.pdf</b></p>
                    </div>
                    <label for="skl_upload" class="col-sm-3 col-form-label">Upload SKL</label>
                    <div class="col-sm-9">
                      <input class="form-control" type="file" id="cover_upload" name="skl_upload" accept=".pdf">
                    </div>

                  </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" id="btntambahsiswaform" class="btn btn-primary">Simpan</button>
              </div>
              </form>
            </div>
          </div>
        </div>

        <!-- import -->
        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#importdatabasesiswa">Import</button>
        <!-- Modal -->
        <div class="modal fade" id="importdatabasesiswa" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Import Siswa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="card">
                  <div class="card-body">
                    <form action="" method="POST" id="importsiswa" enctype="multipart/form-data">

                      <div class="form_group" style="margin-bottom: 5;">
                        <label for="">Unggah File</label>
                        <input type="file" id="filesiswa" name="filesiswa" class="form-control">
                      </div>
                      <br>
                      <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_siswa.xls">Download Template Import Siswa</a></p>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" id="btnimportsiswa" class="btn btn-primary">Import</button>
              </div>
              </form>
            </div>
          </div>
        </div>

        <!-- hapus -->
        <button type="button" class="btn btn-danger" id="hapussiswa">Hapus</button>
        <button type="button" class="btn btn-warning" id="sinkronskl">Sinkron SKL</button>

        <a href="siswa" type="button" class="btn btn-success">Refresh</a>

      </div>


    </div>

    <!-- Modal Edit Password -->
    <div class="modal fade" id="passwordModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="passwordModalLabel">Edit Password</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="editpasswordform">
              <?= csrf_field(); ?>
              <input type="hidden" name="idsiswapassword">
              <div class="row mb-3">
                <label for="Nama" class="col-sm-3 ">Nama</label>
                <div class="col-sm-9">
                  <p id="namapassword"></p>
                </div>
              </div>
              <div class="row mb-3">
                <label for="password" class="col-sm-3 col-form-label">Password</label>
                <div class="col-sm-9">
                  <input type="password" autocomplete="new password" class="form-control" id="editpassword" name="password" placeholder="Masukkan Password">
                </div>
              </div>
              <div class="row mb-3">
                <label for="confimrpassword" class="col-sm-3 col-form-label">Confirm Password</label>
                <div class="col-sm-9">
                  <input type="password" autocomplete="Confirm password" class="form-control" id="editrepassword" name="repassword" placeholder="Confirm Password">
                </div>
              </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table id="tableSiswa" class="table table-striped table-bordered" style="width:100%">
            <thead class="text-center">
              <tr>
                <th><input type="checkbox" id='checkall'></th>
                <th>Action</th>
                <th>Nama</th>
                <th>Kelas</th>
                <th>Username</th>
                <th>No. Induk</th>
                <th>Tempat lahir</th>
                <th>Tgl lahir</th>
                <th>NISN</th>
                <th>Judul SKL</th>
              </tr>
            </thead>
            <tbody>



            </tbody>
            <tfoot class="text-center">
              <tr>
                <th><input type="checkbox" id='checkall'></th>
                <th>Action</th>
                <th>Nama</th>
                <th>Kelas</th>
                <th>Username</th>
                <th>No. Induk</th>
                <th>Tempat lahir</th>
                <th>Tgl lahir</th>
                <th>NISN</th>
                <th>Judul SKL</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
    </div>

  </div>
</div>
<!--end page wrapper -->



</div>
<!--end wrapper-->

<!-- Modal Edit-->
<div class="modal fade" id="editdatabasesiswaModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Siswa</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="" id="editdatabasesiswaform" enctype="multipart/form-data">
          <?= csrf_field(); ?>
          <input type="hidden" name="idsiswa">

          <div class="row mb-3">
            <label for="editusername" class="col-sm-3 col-form-label">Username</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editusername" name="username" placeholder="Masukkan Username">
              <!-- <textarea class="form-control" id="editusername" name="username" placeholder="Masukkan Username" rows="3"></textarea> -->
            </div>
          </div>
          <div class="row mb-3">
            <label for="editno_induk" class="col-sm-3 col-form-label">No. Induk</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editno_induk" name="no_induk" placeholder="Masukkan No. Induk">
            </div>
          </div>

          <div class="row mb-3">
            <label for="editnama" class="col-sm-3 col-form-label">Nama</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editnama" name="nama" placeholder="Masukkan Nama">
            </div>
          </div>
          <div class="row mb-3">
            <label for="editkelas" class="col-sm-3 col-form-label">Kelas</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editkelas" name="kelas" placeholder="Masukkan Kelas">
            </div>
          </div>

          <div class="row mb-3">
            <label for="edittempat_lahir" class="col-sm-3 col-form-label">Tempat Lahir</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="edittempat_lahir" name="tempat_lahir" placeholder="Masukkan Tempat Lahir">
            </div>
          </div>

          <div class="row mb-3">
            <label for="edittgl_lahir" class="col-sm-3 col-form-label">Tgl Lahir</label>
            <div class="col-sm-9">
              <input type="date" class="form-control" id="edittgl_lahir" name="tgl_lahir" placeholder="Masukkan Tanggal Lahir">
            </div>
          </div>

          <div class="row mb-3">
            <label for="editnisn" class="col-sm-3 col-form-label">NISN</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editnisn" name="nisn" placeholder="Masukkan NISN">
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-sm-3"></div>
            <div class="col-sm-9">

              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="cekskl" id="editcekskl">
                <label class="form-check-label" for="cekskl">Ada SKL-nya?</label>
              </div>
            </div>
          </div>
          <div class="row mb-3" id="editformutkjudul">
            <div class="col-sm-3"></div>
            <div class="col-sm-9">
              <p>Penulisan judul file harus dengan ekstensi pdf agar bisa diupload massal di menu media. Contoh <b>buku1.pdf</b></p>
            </div>
            <label for="editjudulskl" class="col-sm-3 col-form-label">Judul File SKL</label>
            <div class="col-sm-9">
              <!-- <input type="text" class="form-control" id="editjudulbuku" name="judulbuku" placeholder="Masukkan Judul File Buku"> -->
              <textarea class="form-control" id="editjudulskl" name="judulskl" placeholder="Masukkan Judul File SKL" rows="2"></textarea>
              <textarea class="form-control" id="editjudulskllama" name="judulskllama" placeholder="Masukkan Judul File Buku" rows="2" hidden></textarea>
            </div>
          </div>
          <div class="row mb-3" hidden id="editformutkskl">
            <div class="col-sm-3"></div>
            <div class="col-sm-9">

              <p>Format file harus berekstensi PDF agar tidak error saat membacanya. Contoh <b>buku1.pdf</b></p>

              <div class="notifskl">

              </div>
              <br>
            </div>
            <label for="skl_upload" class="col-sm-3 col-form-label">Upload SKL</label>
            <div class="col-sm-9">
              <input class="form-control" type="file" id="editcover_upload" name="skl_upload" accept=".pdf">
              <textarea class="form-control" id="editjuduluploadlama" name="juduluploadlama" placeholder="Masukkan Judul File SKL" rows="2" hidden></textarea>
            </div>

          </div>


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" id="btneditsiswa" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    $('#cekskl').click(function() {
      if ($(this).is(':checked')) {
        $('#formutkjudul').prop('hidden', true);
        $('#formutkskl').prop('hidden', false);
      } else {
        $('#formutkjudul').prop('hidden', false);
        $('#formutkskl').prop('hidden', true);
      }
    });


    $('#editcekskl').click(function() {
      if ($(this).is(':checked')) {
        $('#editformutkjudul').prop('hidden', true);
        $('#editformutkskl').prop('hidden', false);
      } else {
        $('#editformutkjudul').prop('hidden', false);
        $('#editformutkskl').prop('hidden', true);


        Swal.fire({
          icon: 'warning',
          title: 'Harap berhati-hati, buku yang tersimpan di data ini akan dihapus jika memilih pilihan ini ',
          // text: 'Ganti hanya teks',
        })
      }
    });
  });
</script>



<script>
  $(document).ready(function() {

    function checkFileExist2(urlToFile2) {
      var xhr = new XMLHttpRequest()
      xhr.onreadystatechange = function() {
        if (this.readyState === this.DONE) {
          console.log(this.status) // do something; the request has completed
          // alert(this.status);
          if (this.status == 404) {
            return false;
          } else {
            return true;
          }
        }
      }
      xhr.open("HEAD", urlToFile2) // replace with URL of your choosing
      xhr.send()
    }


    $("#btntambahsiswa").click(function() {
      $('#cekskl').prop(':checked', false);
      $('#formutkjudul').prop('hidden', false);
      $('#formutkskl').prop('hidden', true);
      $('#tambahsklform')[0].reset();
    });

    //fetch siswa
    function fetchSiswa() {
      $.ajax({
        url: '<?= base_url(); ?>/siswa/fetchsiswa',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          $('#tableSiswa').DataTable({
            "data": data.siswa,
            "responsive": true,
            "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": [{
                extend: 'copyHtml5',
                text: '<i class="fadeIn animated bx bx-copy"></i>',
                titleAttr: 'Copy'
              },
              {
                extend: 'excelHtml5',
                text: 'excel',
                titleAttr: 'Excel',
              },
              {
                extend: 'csvHtml5',
                text: 'csv',
                titleAttr: 'Excel'
              },
              {
                extend: 'pdfHtml5',
                text: 'pdf',
                titleAttr: 'Pdf'
              },
              {
                extend: 'print',
                text: '<i class="lni lni-printer"></i>',
                titleAttr: 'Print'
              },
              {
                extend: 'colvis',
                text: '',
                titleAttr: 'Colvis'
              }
            ],

            "columnDefs": [{
              className: "text-center",
              // className: "dt-body-right-center",
              targets: '_all'
            }],

            "columns": [{
                targets: 0,
                data: null,
                className: 'text-center',
                searchable: false,
                orderable: false,


                "render": function(data, type, row, meta) {
                  var r =
                    '<input type="checkbox" name="checkbox" id = "' + row.id + '"  value = "' + row.id + '" class="delete_checkbox"></input>';

                  return r;
                },
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let a = '';

                  if (`${row.file_exist}` == "ada") {

                    a = `
                    <a href="" class="badge bg-warning text-dark gantipassword" value="${row.id}/${row.nama}"><i class="fadeIn animated bx bx-lock"></i></a>  
                    <a href="" class="badge bg-info text-dark editdatabaseskl" value="${row.id}"><i class="fadeIn animated bx bx-edit-alt"></i></a>
                    <a href="siswa/bacaskl/${row.id}" class="bacaskl badge bg-success text-light" target="_blank"><i class="fadeIn animated bx bx-search-alt-2"></i></a>
                  
                    `;
                  } else {
                    a = `
                    <a href="" class="badge bg-warning text-dark gantipassword" value="${row.id}/${row.nama}"><i class="fadeIn animated bx bx-lock"></i></a>  
                    <a href="" class="badge bg-info text-dark editdatabaseskl" value="${row.id}"><i class="fadeIn animated bx bx-edit-alt"></i></a>
                    <a href="#" class="bacabuku badge bg-danger text-light" ><i class="fadeIn animated bx bx-search-alt-2"></i></a>
                    `;

                  }
                  return a;
                }
              },
              {
                "data": "nama"
              },
              {
                "data": "kelas"
              },
              {
                "data": "username"
              },
              {
                "data": "no_induk"
              },

              {
                "data": "tempat_lahir"
              },
              {
                "data": "tgl_lahir"
              },
              {
                "data": "nisn"
              },
              {
                "data": "nama_file"
              }

            ]
          });
        }
      });
    }

    fetchSiswa();

    // search buku


    // save siswa
    $('#tambahsiswaform').submit(function() {
      event.preventDefault();

      $.ajax({
        url: '<?= base_url(); ?>/siswa/savesiswa',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btntambahsiswaform').attr('disabled');
          $("#btntambahsiswaform").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);
        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tambahsiswa').modal('hide');
            $('#tableSiswa').DataTable().destroy();
            fetchSiswa();
            toastr["success"](data.pesan);

          } else {
            // console.log(data);
            // alert(data.kesalahan);
            // console.log(data.kesalahan);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btntambahsiswaform').removeAttr('disabled');
          $("#btntambahsiswaform").html(`Simpan`);

        },
      });
    });


    //ganti password modal
    $(document).on('click', '.gantipassword', function() {
      event.preventDefault();
      // alert("buka gantipassword");
      $("#editpasswordform")[0].reset();

      let arrayvalue = $(this).attr("value").split("/");

      let idsiswa = arrayvalue[0];
      let namasiswa = arrayvalue[1];


      // let idpetugas = $(this).attr("value");

      $('#passwordModal').modal('show')
      $("input[name='idsiswapassword']").val(idsiswa);
      $("#namapassword").text(namasiswa);
    });

    // edit password
    $('#editpasswordform').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/siswa/editpassword'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        success: function(data) {
          if (data.responce == "success") {
            $('#passwordModal').modal('hide');
            toastr["success"](data.pesan);
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        }
      })
    });


    // modal edit
    $(document).on("click", ".editdatabaseskl", function() {
      event.preventDefault();

      $(".notifskl").children().remove();

      let idsiswa = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/siswa/editmodal'); ?>',
        type: 'post',
        data: {
          idsiswa: idsiswa
        },
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          if (data.responce == 'success') {
            $('#editdatabasesiswaModal').modal('show');

            $("input[name='idsiswa']").val(data.siswa.id);
            $("input[name='username']").val(data.siswa.username);


            $("input[name='no_induk']").val(data.siswa.no_induk);

            $("input[name='nama']").val(data.siswa.nama);
            $("input[name='kelas']").val(data.siswa.kelas);
            $("input[name='tempat_lahir']").val(data.siswa.tempat_lahir);
            $("input[name='tgl_lahir']").val(data.siswa.tgl_lahir);
            $("input[name='nisn']").val(data.siswa.nisn);


            $("#editjudulskl").text(data.siswa.nama_file);
            $("#editjudulskllama").text(data.siswa.nama_file);
            $("#editjuduluploadlama").text(data.siswa.nama_file);

            // alert(data.cekskl);

            if (data.cekskl == "ada") {
              $('#editcekskl').prop('checked', true);
              $('#editformutkjudul').prop('hidden', true);
              $('#editformutkskl').prop('hidden', false);

              $(".notifskl").append('<button type = "button" class = "btn btn-primary">Data ini sudah memiliki file SKL <i class = "bx bx-like"></i> Mau Ganti ? <input class="form-check-input" type="checkbox" value="ganti" id="gantiskl" name="gantiskl"></button> ');
            } else {
              $('#editcekskl').prop('checked', false);
              $('#editformutkjudul').prop('hidden', false);
              $('#editformutkskl').prop('hidden', true);
              $(".notifskl").append('<button type = "button" class = "btn btn-danger">Data ini belum memiliki file SKL <i class = "bx bx-export me-0"></i> <input type="hidden" value="uploadsklbaru" id="uploadsklbaru" name="uploadsklbaru" value="uploadsklbaru"> </button>');
            }


          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // Edit siswa
    $("#editdatabasesiswaform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/siswa/editsiswa',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btneditsiswa').attr('disabled');
          $("#btneditsiswa").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);
        },
        success: function(data) {
          if (data.responce == "success") {
            // console.log(data.update);
            $('#tableSiswa').DataTable().destroy();
            fetchSiswa();
            $('#editdatabasesiswaModal').modal('hide');
            toastr["success"](data.pesan);
          } else {

            // alert(data.kesalahan);
            // console.log(data.kesalahan);
            toastr["error"](data.pesan);
          }


        },
        complete: function() {
          $('#btneditsiswa').removeAttr('disabled');
          $("#btneditsiswa").html(`Update`);

        },
      });


    });


    // Check all 
    $('#checkall').click(function() {
      if ($(this).is(':checked')) {
        $('.delete_checkbox').prop('checked', true);
      } else {
        $('.delete_checkbox').prop('checked', false);
      }
    });

    $('.delete_checkbox').click(function() {
      if ($(this).is(':checked')) {
        $(this).closest('tr').addClass('removeRow');
      } else {
        $(this).closest('tr').removeClass('removeRow');
      }
    });

    //hapus siswa
    $('#hapussiswa').click(function() {

      var checkbox = $('.delete_checkbox:checked');

      if (checkbox.length > 0) {
        Swal.fire({
          title: 'Apa kamu yakin ingin menghapus ' + checkbox.length + ' siswa?',
          text: "kamu tidak akan bisa mengembalikannya!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, hapus saja!'
        }).then((result) => {
          if (result.isConfirmed) {

            var checkbox_value = [];
            $(checkbox).each(function() {
              checkbox_value.push($(this).val());
            });

            // console.log(checkbox);
            $.ajax({
              url: '<?= base_url('/siswa/deletesiswa'); ?>',
              type: "POST",
              data: {
                checkbox_value: checkbox_value
              },
              dataType: 'json',
              success: function(data) {
                if (data.responce == "success") {
                  // toastr["success"](data.pesan);
                  Swal.fire(
                    'Deleted!',
                    'Siswa berhasil dihapus.',
                    'success'
                  )
                  $('#tableSiswa').DataTable().destroy();
                  fetchSiswa();
                } else {
                  Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Ada yang tidak beres!',
                  })
                }
              }
            })

          }
        })

      } else {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: 'Pilih minimal satu data',
        })

      }
    });


    // import siswa
    $('#importsiswa').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/siswa/importsiswa'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnimportsiswa').attr('disabled');
          $("#btnimportsiswa").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);
        },
        success: function(data) {
          if (data.responce == "success") {
            // console.log(data.cekuser)
            // console.log(data.ceknik)
            $('#tableSiswa').DataTable().destroy();
            fetchSiswa();
            $('#importdatabasesiswa').modal('hide');
            // toastr["success"](data.pesan);
            Swal.fire(
              'Import Selesai',
              'Terdapat ' + data.angkasukses + ' data sukses diimport dan ' + data.angkagagal + ' data gagal diimport terdiri dari ' + data.angkadoublesiswa + ' data double file siswa pada baris ' + data.barisdoublesiswa + ' .',
              'success'
            )
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnimportsiswa').removeAttr('disabled');
          $("#btnimportsiswa").html(`Update`);

        },
      });

    });

    // sinkron buku
    $('#sinkronskl').click(function() {

      Swal.fire({
        title: 'Apa kamu ingin menyinkronkan SKL dengan database file?',
        // text: "kamu tidak akan bisa mengembalikannya!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Sinkronkan saja!'
      }).then((result) => {
        if (result.isConfirmed) {

          // console.log(checkbox);
          $.ajax({
            url: '<?= base_url('/siswa/sinkronskl'); ?>',
            type: "POST",
            dataType: 'json',
            success: function(data) {
              if (data.responce == "success") {
                // toastr["success"](data.pesan);
                Swal.fire({
                  icon: 'success',
                  title: 'SKL telah berhasil disinkronkan',
                  text: 'SKL yang kosong ada ' + data.jumlahsklkosong + ' dengan judul ' + data.sklkosong
                })
                $('#tableSiswa').DataTable().destroy();
                fetchSiswa();
              } else {
                Swal.fire({
                  icon: 'error',
                  title: 'Oops...',
                  text: 'Ada yang tidak beres!',
                })
              }
            }
          })

        }
      })
    });



  });
</script>


<?= $this->endSection(); ?>