<?= $this->extend('backend/layout/template_admin'); ?>


<?= $this->section('content'); ?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
      <div class="breadcrumb-title pe-3">Applications</div>
      <div class="ps-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0 p-0">
            <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">File Manager</li>
          </ol>
        </nav>
      </div>

    </div>
    <!--end breadcrumb-->
    <div class="row">
      <div class="col-12 col-lg-4">
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col-xl-9 mx-auto">
                <h6 class="mb-0 text-uppercase">Upload File</h6>
                <hr />
                <div class="card">
                  <div class="card-body">
                    <!-- <button class="btn btn-success" style="float: right;" id="uploadBtn">Upload</button> -->

                    <form enctype="multipart/form-data" id="image-upload" class="dropzone">

                      <!-- <div>
                        <h3 class="text-center">Upload Multiple Image By Click On Box</h3>
                      </div> -->
                    </form>
                  </div>
                </div>

              </div>
            </div>
            <h5 class="my-3">Folder</h5>
            <div class="fm-menu">
              <div class="list-group list-group-flush"> <a href="javascript:;" class="list-group-item py-1"><i class='bx bx-folder me-2'></i><span>SKL</span></a>
              </div>
            </div>
          </div>
        </div>

      </div>
      <div class="col-12 col-lg-8">
        <div class="card">
          <div class="card-body">
            <div class="fm-search">
              <div class="mb-0">

                <form action="<?= base_url(); ?>/fileskl" method="get">
                  <div class="input-group input-group-lg">
                    <button class="btn btn-outline-secondary" type="submit" id="cariskl">

                      <i class='bx bx-search'></i>

                    </button>
                    <input type="text" class="form-control" name="cariskl" placeholder="Search the files">
                    <a href="<?= base_url(); ?>/fileskl" class="btn btn-info">
                      Refresh
                    </a>
                  </div>
                </form>


                <!-- <div class="alert alert-info border-0 bg-info alert-dismissible fade show py-2">
                  <div class="d-flex align-items-center">
                    <div class="font-35 text-dark"><i class='bx bx-info-square'></i>
                    </div>
                    <div class="ms-3">
                      <h6 class="mb-0 text-dark">Info</h6>
                      <div class="text-dark</div>
                    </div>
                  </div>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> -->

              </div>
            </div>
            <div class="row mt-3">

              <?php foreach ($folderskl as $folderskl) : ?>
                <div class="col-4 col-lg-2">
                  <div class="card shadow-none border radius-15">
                    <div class="card-body">
                      <center>
                        <img src="<?= base_url(); ?>/asset/images/pdflogo.png" class="logo-icon">
                      </center>


                      <?php
                      if (strlen($folderskl['fileskl']) > 20) {
                        $judulbaru = substr($folderskl['fileskl'], 0, 19);
                      } else {
                        $judulbaru = $folderskl['fileskl'];
                      }
                      ?>
                      <h6 class="mt-3 mb-2 text-center"><?= $judulbaru; ?></h6>

                      <center>
                        <?php if (in_array($folderskl['fileskl'], $skllink)) {
                        ?>
                          <a class="btn btn-success btn-sm mb-1">Link</a><br>
                        <?php
                        } else {
                        ?>
                          <a class="btn btn-warning btn-sm mb-1">No Link</a><br>
                        <?php
                        } ?>
                        <a href="#" value="<?= $folderskl['fileskl']; ?>" class="btn btn-danger btn-sm mb-1 deletefile">Delete</a>
                        <a href="<?= base_url(); ?>/fileskl/download/<?= $folderskl['id']; ?>" target="_blank" class="btn btn-info btn-sm downloadfile">Download</a>
                      </center>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>


              <div class="row justify-content-center align-items-center">
                <div class="col">

                  <?php

                  if ($keterangan == "cariskl") {
                    echo $pager->links('cariskl', 'page_template');
                  } else {
                    echo $pager->links('folderskl', 'page_template');
                  }

                  ?>

                </div>
              </div>

            </div>
            <!--end row-->


          </div>
        </div>
      </div>
    </div>
    <!--end row-->
  </div>
</div>
<!--end page wrapper -->



<script type="text/javascript">
  // Dropzone.autoDiscover = false;

  Dropzone.options.imageUpload = {
    url: "<?= base_url(); ?>/fileskl/addfile",
    paramName: "file",
    method: "post",
    // uploadMultiple: true,
    maxFilesize: 20,
    acceptedFiles: ".pdf",
    addRemoveLinks: true,

  };
</script>


<script>
  $(document).ready(function() {

    // delete file
    $(document).on("click", ".deletefile", function() {
      event.preventDefault();
      let namafile = $(this).attr('value');

      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya dan buku yang mempunyai link ke file ini dianggap kosong",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/fileskl/deletefile'); ?>/' + namafile,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {

              Swal.fire(
                'Deleted!',
                'File sudah terdelete.',
                'success'
              )
              setTimeout(function() {
                /* show the alert for 3sec and then reload the page. */
                location.reload();
              }, 1500);
            }
          });

        }
      })
    });
  })
</script>

<?= $this->endSection(); ?>