<?php

namespace App\Controllers;

use PHPExcel;

use PHPExcel_IOFactory;
use App\Models\LoginModel;
use App\Models\SiswaModel;
use App\Models\SettingModel;
use CodeIgniter\Controller;
use App\Models\FilesklModel;

class Siswa extends BaseController
{

  protected $loginModel;
  protected $settingModel;
  protected $siswaModel;
  protected $filesklModel;


  public function __construct()
  {
    helper('fisi_helper');
    helper('date');
    $this->loginModel = new LoginModel();
    $this->siswaModel = new SiswaModel();
    $this->settingModel = new SettingModel();
    $this->filesklModel = new FilesklModel();
  }

  public function index()
  {
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
    $setting = $this->settingModel->get()->getRowArray();
    // dd($submenu);

    $data = [
      'title' => 'Siswa Page',
      'user' => $cekuser
    ];

    return view('backend/siswa', $data);
  }

  public function fetchsiswa()
  {
    if ($this->request->isAJAX()) {
      if ($siswa = $this->siswaModel->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'siswa' => $siswa
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch siswa'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function savesiswa()
  {
    if ($this->request->isAjax()) {


      if (!$this->validate([
        'username' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Username tidak boleh kosong'
          ]
        ],
        'password' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'password tidak boleh kosong'

          ]
        ],
        'repassword' => [
          'rules' => 'required|matches[password]',
          'errors' => [
            'required' => 'repassword tidak boleh kosong',
            'matches' => 're-password tidak sesuai'
          ]
        ],
        'no_induk' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'No. Induk tidak boleh kosong'

          ]
        ],
        'nama' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'nama tidak boleh kosong'

          ]
        ],
        'kelas' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'kelas tidak boleh kosong'

          ]
        ],
        'tempat_lahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'tempat lahir tidak boleh kosong'

          ]
        ],
        'tgl_lahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tgl Lahir tidak boleh kosong'

          ]
        ],
        'nisn' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'NISN tidak boleh kosong'

          ]
        ],

      ])) {
        $validation = \Config\Services::validation();
        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses

        $cekskl = $this->request->getVar('cekskl');
        $skl_upload = $this->request->getFile('skl_upload');

        $username = anti_injection($this->request->getVar('username'));
        $passsword = anti_injection(password_hash($this->request->getVar('password'), PASSWORD_DEFAULT));
        $no_induk = anti_injection($this->request->getVar('no_induk'));
        $nama = anti_injection($this->request->getVar('nama'));
        $kelas = anti_injection($this->request->getVar('kelas'));
        $tempat_lahir = anti_injection($this->request->getVar('tempat_lahir'));
        $tgl_lahir = anti_injection($this->request->getVar('tgl_lahir'));
        $nisn = anti_injection($this->request->getVar('nisn'));

        $judulskl = anti_injection($this->request->getVar('judulskl'));

        $ext = $skl_upload->guessExtension();

        $cekjudulfile = $this->siswaModel->findColumn('nama_file');

        if (empty($cekjudulfile)) {
          $rulecekjudulfile = false;
        } else {
          $rulecekjudulfile = in_array($judulskl, $cekjudulfile);
        }

        //jika checkbox skl tidak diceklist
        if ($cekskl != "on") {

          if ($judulskl == "") {
            $data = [
              'responce' => 'error',
              'pesan' => "Judul SKL tidak boleh kosong"
            ];
          } elseif (substr($judulskl, -4) != ".pdf") {

            $data = [
              'responce' => 'error',
              'pesan' => "File SKL belum ditambah tulisan <b>.pdf</b> di akhirnya"
            ];
          } elseif ($rulecekjudulfile) {
            $data = [
              'responce' => 'error',
              'pesan' => "Judul File Buku sudah ada, silahkan rename filenya dulu",
              // 'kesalahan' => count($cekjudulfile)
            ];
          } else {
            $skl = $judulskl;

            $insert = [
              'username' => $username,
              'password' => $passsword,
              'no_induk' => $no_induk,
              'nama' => $nama,
              'kelas' => $kelas,
              'tempat_lahir' => $tempat_lahir,
              'tgl_lahir' => $tgl_lahir,
              'nisn' => $nisn,
              'nama_file' => $judulskl,
              'file_exist' => "kosong",
            ];


            $this->siswaModel->insert($insert);

            $data = [
              'responce' => 'success',
              'pesan' => 'siswa berhasil ditambah'
            ];
          }
        }
        //jika checkbox skl dichecklist
        else {
          if ($skl_upload->getError() == 4 or $ext != 'pdf') {
            $data = [
              'responce' => 'error',
              'pesan' => "File SKL Kosong Atau Bukan jenis PDF"
            ];
          } else {
            // $buku = $buku_upload->getName();

            $judultanpaspasi = str_replace(' ', '', $nama);
            $skl = $judultanpaspasi . '' . $nisn .   '.' . $ext;



            $skl_upload->move('asset/skl', $skl);

            $insert = [
              'username' => $username,
              'password' => $passsword,
              'no_induk' => $no_induk,
              'nama' => $nama,
              'kelas' => $kelas,
              'tempat_lahir' => $tempat_lahir,
              'tgl_lahir' => $tgl_lahir,
              'nisn' => $nisn,
              'nama_file' => $skl,
              'file_exist' => "ada",
            ];

            $insertfileskl = [
              'fileskl' => $skl
            ];

            $this->siswaModel->insert($insert);
            $this->filesklModel->insert($insertfileskl);

            $data = [
              'responce' => 'success',
              'pesan' => 'Siswa berhasil ditambah'
            ];
          }
        }
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }


  public function editpassword()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([
        'password' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'password tidak boleh kosong'

          ]
        ],
        'repassword' => [
          'rules' => 'required|matches[password]',
          'errors' => [
            'required' => 'repassword tidak boleh kosong',
            'matches' => 're-password tidak sesuai'
          ]
        ],
      ])) {
        $validation = \Config\Services::validation();
        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $id = $this->request->getVar('idsiswapassword');
        $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
        $update = [
          'password' => $password,
        ];


        $this->siswaModel->update($id, $update);

        $data = [
          'responce' => 'success',
          'pesan' => 'Password berhasil diupdate'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editmodal()
  {
    if ($this->request->isAJAX()) {
      // $cekuser = $this->karyawanModel->where('id', session('id'))->get()->getRowArray();
      $idsiswa = anti_injection($this->request->getVar('idsiswa'));
      if ($siswa = $this->siswaModel->where('id', $idsiswa)->get()->getRowArray()) {

        $judulskl = $siswa['nama_file'];

        if (file_exists('asset/skl/' . $judulskl)) {
          $cekskl = "ada";
        } else {
          $cekskl = "kosong";
        }


        $data = [
          'responce' => 'success',
          'siswa' => $siswa,
          'cekskl' => $cekskl
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal memunculkan modal edit data'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editsiswa()
  {
    if ($this->request->isAJAX()) {

      if (!$this->validate([
        'username' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Username tidak boleh kosong'
          ]
        ],
        'no_induk' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nomor Induk tidak boleh kosong'
          ]
        ],
        'nama' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama tidak boleh kosong'
          ]
        ],
        'kelas' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Kelas tidak boleh kosong'
          ]
        ],
        'tempat_lahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tempat lahir tidak boleh kosong'
          ]
        ],
        'tgl_lahir' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'tgl lahir tidak boleh kosong'
          ]
        ],
        'nisn' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'NISN tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses

        $cekskl = $this->request->getVar('cekskl');
        $skl_upload = $this->request->getFile('skl_upload');

        $idsiswa = anti_injection($this->request->getVar('idsiswa'));
        $username = anti_injection($this->request->getVar('username'));
        $no_induk = anti_injection($this->request->getVar('no_induk'));
        $nama = anti_injection($this->request->getVar('nama'));
        $kelas = anti_injection($this->request->getVar('kelas'));
        $tempat_lahir = anti_injection($this->request->getVar('tempat_lahir'));
        $tgl_lahir = anti_injection($this->request->getVar('tgl_lahir'));
        $nisn = anti_injection($this->request->getVar('nisn'));


        $judulskl = anti_injection($this->request->getVar('judulskl'));
        $judulskllama = anti_injection($this->request->getVar('judulskllama'));

        $ext = $skl_upload->guessExtension();

        $cekjudulfile = $this->siswaModel->findColumn('nama_file');

        if ($judulskl == $judulskllama) {
          $rulecekjudulfile = false;
        } else {
          $rulecekjudulfile = in_array($judulskl, $cekjudulfile);
        }

        //jika checkbox skl tidak dichecklist
        if ($cekskl != "on") {

          if ($judulskl == "") {
            $data = [
              'responce' => 'error',
              'pesan' => "Judul File SKL tidak boleh kosong"
            ];
          } elseif (substr($judulskl, -4) != ".pdf") {

            $data = [
              'responce' => 'error',
              'pesan' => "File belum ditambah tulisan <b>.pdf</b> di akhirnya"
            ];
          } elseif ($rulecekjudulfile) {
            $data = [
              'responce' => 'error',
              'pesan' => "Judul File SKL sudah ada, silahkan rename filenya dulu",
              // 'kesalahan' => count($cekjudulfile)
            ];
          } else {
            // $skl = $judulskllama;

            if ($this->filesklModel->where('fileskl', $judulskllama)->get()->getRowArray()) {
              $this->filesklModel->where('fileskl', $judulskllama)->delete();
            }

            if (file_exists('asset/skl/' . $judulskllama)) {
              unlink('asset/skl/' . $judulskllama);
            }

            $update = [
              'username' => $username,
              'no_induk' => $no_induk,
              'nama' => $nama,
              'kelas' => $kelas,
              'tempat_lahir' => $tempat_lahir,
              'tgl_lahir' => $tgl_lahir,
              'nisn' => $nisn,
              'nama_file' => $judulskl,

              'file_exist' => "kosong",

            ];

            $this->siswaModel->update($idsiswa, $update);
            $data = [
              'responce' => 'success',
              'pesan' => 'Data berhasil diupdate'
            ];
          }
        }
        //jika checkbox skl dichecklist
        else {

          $gantiskl = $this->request->getVar('gantiskl');
          //ganti skl baru yang update
          if ($gantiskl == "ganti") {
            if ($skl_upload->getError() == 4 or $ext != 'pdf') {
              $data = [
                'responce' => 'error',
                'pesan' => "File SKL Kosong Atau Bukan jenis PDF",
                'kesalahan' => $gantiskl
              ];
            } else {
              // $buku = $buku_upload->getName();

              $juduluploadlama = anti_injection($this->request->getVar('juduluploadlama'));

              $judultanpaspasi = str_replace(' ', '', $nama);
              $sklbaru = $judultanpaspasi . '' . $nisn .   '.' . $ext;



              if (file_exists('asset/skl/' . $juduluploadlama)) {
                unlink('asset/skl/' . $juduluploadlama);
              }

              $skl_upload->move('asset/skl', $sklbaru);

              $this->filesklModel->where('fileskl', $juduluploadlama)->delete();

              // $this->filebukuModel->where('filebuku', $juduluploadlama)->delete();


              $update = [
                'username' => $username,
                'no_induk' => $no_induk,
                'nama' => $nama,
                'kelas' => $kelas,
                'tempat_lahir' => $tempat_lahir,
                'tgl_lahir' => $tgl_lahir,
                'nisn' => $nisn,
                'nama_file' => $sklbaru,

                'file_exist' => "ada",
              ];

              $insertfileskl = [
                'fileskl' => $sklbaru
              ];

              $this->siswaModel->update($idsiswa, $update);
              $this->filesklModel->insert($insertfileskl);
              $data = [
                'responce' => 'success',
                'pesan' => 'Data berhasil diupdate'
              ];
            }
          } elseif ($this->request->getVar('uploadsklbaru') != "") {

            if ($skl_upload->getError() == 4 or $ext != 'pdf') {
              $data = [
                'responce' => 'error',
                'pesan' => "File SKL Kosong Atau Bukan jenis PDF"
              ];
            } else {
              $judultanpaspasi = str_replace(' ', '', $nama);
              $sklbaru = $judultanpaspasi . '' . $nisn  . '.' . $ext;

              $skl_upload->move('asset/skl', $sklbaru);

              // $this->filesklModel->where('fileskl', $juduluploadlama)->delete();


              $update = [
                'username' => $username,
                'no_induk' => $no_induk,
                'nama' => $nama,
                'kelas' => $kelas,
                'tempat_lahir' => $tempat_lahir,
                'tgl_lahir' => $tgl_lahir,
                'nisn' => $nisn,
                'nama_file' => $sklbaru,

                'file_exist' => "ada",

              ];

              $insertfileskl = [
                'fileskl' => $sklbaru
              ];

              $this->siswaModel->update($idsiswa, $update);
              $this->filesklModel->insert($insertfileskl);
              $data = [
                'responce' => 'success',
                'pesan' => 'Data berhasil diupdate'
              ];
            }
          } else {

            $update = [
              'username' => $username,
              'no_induk' => $no_induk,
              'nama' => $nama,
              'kelas' => $kelas,
              'tempat_lahir' => $tempat_lahir,
              'tgl_lahir' => $tgl_lahir,
              'nisn' => $nisn,
              'file_exist' => "ada",

            ];

            $this->siswaModel->update($idsiswa, $update);
            $data = [
              'responce' => 'success',
              'pesan' => 'Data berhasil diupdate'
            ];
          }
        }
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function deletesiswa()
  {
    if ($this->request->isAJAX()) {
      if ($id = $this->request->getVar('checkbox_value')) {
        for ($count = 0; $count < count($id); $count++) {
          // $this->karyawanModel->delete_karyawan($id[$count]);
          $siswa = $this->siswaModel->where('id', $id[$count])->get()->getRowArray();

          // if ($filebuku = $this->filebukuModel->where('filebuku', $buku['buku'])->get()->getRowArray()) {

          //   $this->filebukuModel->where('filebuku', $buku['buku'])->delete();
          // }


          if ($siswa['nama_file'] != '') {
            if (file_exists('asset/skl/' . $siswa['nama_file'])) {
              unlink('asset/skl/' . $siswa['nama_file']);
            }
          }


          $this->siswaModel->where('id', $id[$count])->delete();
        }

        $data = [
          'responce' => 'success',
          'pesan' => 'Siswa berhasil dihapus'
        ];

        echo json_encode($data);
      }
    } else {
      echo "No direct script access allowed";
    }
  }

  public function sinkronskl()
  {
    if ($this->request->isAJAX()) {

      $siswa = $this->siswaModel->findAll();

      $sklkosong = array();
      foreach ($siswa as $siswa) {

        if (file_exists('asset/skl/' . $siswa['nama_file'])) {
          $updateskl = "ada";
        } else {
          $updateskl = "kosong";
          array_push($sklkosong, $siswa['nama_file']);
        }

        $update = [
          'file_exist' => $updateskl,
        ];

        $this->siswaModel->update($siswa['id'], $update);
      }

      $jumlahsklkosong = count($sklkosong);

      $data = [
        'responce' => 'success',
        'pesan' => 'Semua SKL telah berhasil disinkronkan',
        'sklkosong' => $sklkosong,
        'jumlahsklkosong' => $jumlahsklkosong
      ];

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function importsiswa()
  {
    if ($this->request->isAJAX()) {

      $file = $this->request->getFile('filesiswa');

      if ($file) {
        $excelReader  = new PHPExcel();

        // $excelReader->setReadDataOnly(true);
        //mengambil lokasi temp file
        $fileLocation = $file->getTempName();
        //baca file
        $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
        //ambil sheet active
        $sheet    = $objPHPExcel->getActiveSheet()->toArray('', true, true, true);

        $angkasukses = 0;
        $angkagagal = 0;
        $angkadoublesiswa = 0;

        $barisdoublesiswa = array();

        // $koderak = $this->rakbukuModel->findColumn('rakbuku_kode');

        foreach ($sheet as $idx => $data) {
          //skip index 1 karena title excel
          if ($idx == 1) {
            continue;
          }

          $username = $data['B'];
          $password = $data['C'];
          $no_induk = $data['D'];
          $nama = $data['E'];
          $kelas = $data['F'];
          $tempat_lahir = $data['G'];
          $tgl_lahir = $data['H'];

          $nisn = $data['I'];
          $nama_file = $data['J'];

          // $idkaryawan = $this->karyawanModel->where('nip', $nip)->get()->getRowArray();
          // $cekfilebuku = $this->bukuModel->cekFileBuku($buku);
          $ceknisn = $this->siswaModel->cekNisn($nisn);



          if ($ceknisn > 0) {
            // $insert = [];
            $angkagagal++;
            $angkadoublesiswa++;
            array_push($barisdoublesiswa, $idx);
          } else {
            $insert = [
              'username' => $username,
              'password' => password_hash($password, PASSWORD_DEFAULT),
              'no_induk' => $no_induk,
              'nama' => $nama,
              'kelas' => $kelas,
              'tempat_lahir' => $tempat_lahir,
              'tgl_lahir' => tanggal($tgl_lahir),
              // 'tgl_lahir' => $tgl_lahir,
              'nisn' => $nisn,
              'nama_file' => $nama_file,
              'file_exist' => "kosong",
            ];

            $this->siswaModel->insert($insert);
            $angkasukses++;
          }
          // insert data
        }

        $data = [
          'responce' => 'success',
          'pesan' => 'Import Database Siswa Berhasil',
          'angkasukses' => $angkasukses,
          'angkagagal' => $angkagagal,
          'angkadoublesiswa' => $angkadoublesiswa,
          'barisdoublesiswa' => $barisdoublesiswa
        ];
      } else {
        //upload gagal
        $data = [
          'responce' => 'error',
          'pesan' => 'Import database siswa gagal'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function bacaskl($id)
  {

    $siswa = $this->siswaModel->where('id', $id)->get()->getRowArray();
    $setting = $this->settingModel->get()->getRowArray();

    $data = [
      'title' => "SKL kelulusan MIJ",
      'fileskl' => $siswa['nama_file'],
      'datasekolah' => $setting

    ];

    // echo $html;
    // return view('sign_in', $data);
    return view('backend/bacaskl', $data);
  }
}
