<?php

namespace App\Controllers;

use App\Models\LoginModel;
use App\Models\SiswaModel;
use App\Models\SettingModel;
use CodeIgniter\Controller;

class Setting extends BaseController
{

  protected $loginModel;
  protected $settingModel;


  public function __construct()
  {
    $this->loginModel = new LoginModel();
    $this->siswaModel = new SiswaModel();
    $this->settingModel = new SettingModel();
  }

  public function index()
  {
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
    $setting = $this->settingModel->get()->getRowArray();
    // dd($submenu);

    $data = [
      'title' => 'Setting Page',
      'user' => $cekuser,
      'setting' => $setting
    ];

    return view('backend/setting', $data);
  }

  public function edit()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([
        'nama_sekolah' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama Sekolah tidak boleh kosong'
          ]
        ],
        'tahun_ajaran' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tahun ajaran tidak boleh kosong'
          ]
        ],
        'tgl_buka' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tanggal tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        $id = $this->request->getVar('id');
        $nama_sekolah = $this->request->getVar('nama_sekolah');
        $tahun_ajaran = $this->request->getVar('tahun_ajaran');
        $tglbuka = $this->request->getVar('tgl_buka');


        $update = [
          'nama_sekolah' => $nama_sekolah,
          'tahun_ajaran' => $tahun_ajaran,
          'tgl_buka' => $tglbuka
        ];

        $this->settingModel->update($id, $update);

        $data = [
          'responce' => 'success',
          'pesan' => 'Tanggal berhasil diupdate',
          'update' => $update
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }
}
