<?php

namespace App\Controllers;

use App\Models\LoginModel;
use App\Models\SiswaModel;
use App\Models\SettingModel;
use CodeIgniter\Controller;

class User extends BaseController
{

  protected $loginModel;
  protected $settingModel;
  protected $siswaModel;


  public function __construct()
  {
    $this->loginModel = new LoginModel();
    $this->siswaModel = new SiswaModel();
    $this->settingModel = new SettingModel();
  }

  public function index()
  {
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
    $setting = $this->settingModel->get()->getRowArray();
    // dd($submenu);

    $data = [
      'title' => 'Admin Page',
      'user' => $cekuser,
      'setting' => $setting
    ];

    return view('backend/user', $data);
  }

  public function fetchuser()
  {
    if ($this->request->isAJAX()) {
      if ($user = $this->loginModel->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'user' => $user
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch jabatan'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function saveuser()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([
        'username' => [
          'rules' => 'required|is_unique[user.username]',
          'errors' => [
            'required' => 'Username tidak boleh kosong',
            'is_unique' => 'Username sudah ada'
          ]
        ],
        'password' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'password tidak boleh kosong'

          ]
        ],
        'repassword' => [
          'rules' => 'required|matches[password]',
          'errors' => [
            'required' => 'repassword tidak boleh kosong',
            'matches' => 're-password tidak sesuai'
          ]
        ],
        'nama' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses

        $username = $this->request->getVar('username');
        $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
        $nama = $this->request->getVar('nama');


        $insert = [
          'username' => $username,
          'password' => $password,
          'nama' => $nama,
        ];


        $this->loginModel->insert($insert);
        $data = [
          'responce' => 'success',
          'pesan' => 'User berhasil ditambah'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editmodal()
  {
    if ($this->request->isAJAX()) {
      $iduser = $this->request->getVar('iduser');
      if ($user = $this->loginModel->where('id', $iduser)->get()->getRowArray()) {
        $data = [
          'responce' => 'success',
          'user' => $user
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal memunculkan modal edit data'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function edituser()
  {
    if ($this->request->isAJAX()) {

      $usernamelama = $this->request->getVar('usernamelama');
      $usernamebaru = $this->request->getVar('username');

      if ($usernamelama == $usernamebaru) {
        $ruleuser = 'required';
      } else {
        $ruleuser = 'required|is_unique[user.username]';
      }

      if (!$this->validate([
        'username' => [
          'rules' => $ruleuser,
          'errors' => [
            'required' => 'Username tidak boleh kosong',
            'is_unique' => 'Data Username sudah ada'
          ]
        ],
        'nama' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();
        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $iduser = $this->request->getVar('idpetugas');
        $update = [
          'username' => $this->request->getVar('username'),
          'nama' => $this->request->getVar('nama')
        ];


        $this->loginModel->update($iduser, $update);

        $data = [
          'responce' => 'success',
          'pesan' => 'User berhasil diupdate'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editpassword()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([
        'password' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'password tidak boleh kosong'

          ]
        ],
        'repassword' => [
          'rules' => 'required|matches[password]',
          'errors' => [
            'required' => 'repassword tidak boleh kosong',
            'matches' => 're-password tidak sesuai'
          ]
        ],
      ])) {
        $validation = \Config\Services::validation();
        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $iduser = $this->request->getVar('iduser');
        $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
        $update = [
          'password' => $password,
        ];


        $this->loginModel->update($iduser, $update);

        $data = [
          'responce' => 'success',
          'pesan' => 'Password berhasil diupdate'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function deleteuser($id)
  {
    if ($this->request->isAJAX()) {
      $this->loginModel->where('id', $id)->delete();
    } else {
      echo "No direct script access allowed";
    }
  }
}
