<?php

namespace App\Controllers;

use App\Models\LoginModel;
use App\Models\SiswaModel;
use App\Models\SettingModel;
use CodeIgniter\Controller;

class Frontend extends BaseController
{

  protected $loginModel;
  protected $siswaModel;
  protected $settingModel;


  public function __construct()
  {
    $this->loginModel = new LoginModel();
    $this->siswaModel = new SiswaModel();
    $this->settingModel = new SettingModel();
  }

  public function login()
  {

    date_default_timezone_set('Asia/Jakarta');
    $tglnow = date("Y-m-d G:i:s");


    $setting = $this->settingModel->get()->getRowArray();

    $data = [
      'title' => 'Login Siswa',
      'validation' => \Config\Services::validation(),
      'setting' => $setting,
      'tglnow' => $tglnow,
    ];

    // return view('loginsiswa', $data);
    // return view('welcome_message');

    if ($tglnow >= $setting['tgl_buka']) {
      return view('loginsiswa', $data);
    } else {
      return view('countdown', $data);
    }
  }

  public function ceklogin()
  {
    if (!$this->validate([
      'username' => [
        'rules'  => 'required',
        'errors' => [
          'required' => 'Username tidak boleh kosong.'
        ]
      ],
      'password'    => [
        'rules'  => 'required',
        'errors' => [
          'required' => 'Password tidak boleh kosong.'
        ]
      ],
    ])) {

      $validation =  \Config\Services::validation();
      $valid = [
        'username' => $validation->getError('username'),
        'password' => $validation->getError('password'),
      ];
      $data = [
        'success' => false,
        'validation' => $valid
      ];
    } else {
      // validasi sukses
      $username = $this->request->getVar('username');
      $password = $this->request->getVar('password');

      $ceklog = $this->siswaModel->where('username', $username)->findAll();
      $ceklogcount = $this->siswaModel->where('username', $username)->countAllResults();
      // dd($ceklog);

      if ($ceklogcount < 1) {
        $data = [
          'success' => true,
          'responce' => 'not',
          'ceklog' => $ceklog
        ];
      } else {
        if (password_verify($password, $ceklog[0]['password'])) {
          // if ($password == $ceklog[0]['password']) {
          $data = [
            'success' => true,
            'responce' => 'yes',
            'ceklog' => $ceklog
          ];
          $user = [
            'id' => $ceklog[0]['id'],
            'username' => $ceklog[0]['username'],
            'password' => $ceklog[0]['password'],
            'nama' => $ceklog[0]['nama'],

          ];
          session()->set($user);
        } else {
          $data = [
            'success' => true,
            'responce' => 'not',
            'ceklog' => $ceklog
          ];
        }
      }
    }

    return json_encode($data);
  }

  public function logout()
  {
    session()->destroy();
    return redirect()->to(base_url('/'));
  }

  public function home()
  {

    $cekuser = $this->siswaModel->where('id', session('id'))->get()->getRowArray();
    // $jumlahsiswa = $this->siswaModel->countAll();
    // $jumlahlunas = $this->capesModel->where('status_pembayaran', 'sudah')->countAllResults();
    // $jumlahuser = $this->loginModel->countAll();
    // dd($submenu);

    $data = [
      'title' => 'Dashboard',
      'siswa' => $cekuser,
      // 'jumlahsiswa' => $jumlahsiswa,
      // 'jumlahlunas' => $jumlahlunas,
      // 'jumlahuser' => $jumlahuser
    ];

    return view('dashboard', $data);
  }

  public function lihatskl($id)
  {

    $siswa = $this->siswaModel->where('id', $id)->get()->getRowArray();
    $setting = $this->settingModel->get()->getRowArray();

    $data = [
      'title' => "SKL kelulusan MIJ",
      'fileskl' => $siswa['nama_file'],
      'datasekolah' => $setting

    ];

    // echo $html;
    // return view('sign_in', $data);
    return view('backend/bacaskl', $data);
  }
}
