<?php

namespace App\Controllers;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\Controller;
use CodeIgniter\BaseController;
use App\Models\LoginModel;
use App\Models\SiswaModel;
use App\Models\SettingModel;
use App\Models\FilesklModel;

use CodeIgniter\HTTP\Request;

class Fileskl extends Controller
{


  protected $loginModel;
  protected $settingModel;
  protected $siswaModel;
  protected $filesklModel;

  public function __construct()
  {
    helper('fisi_helper');

    helper('date');
    helper('filesystem');
    $this->loginModel = new LoginModel();
    $this->siswaModel = new SiswaModel();
    $this->settingModel = new SettingModel();
    $this->filesklModel = new FilesklModel();
  }

  protected $request;


  public function index()
  {

    $pager = \Config\Services::pager();


    $skllink = $this->siswaModel->findColumn('nama_file');
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();


    if ($cariskl = $this->request->getGet('cariskl')) {

      $query = $this->filesklModel->pencarian($cariskl);


      // $jumlah = "Pencarian dengan kata kunci <B>$caribuku</B> ditemukan " . $query->affectedRows() . " Data";

      $folderskl = $query->paginate(30, 'cariskl');
      $pager = $this->filesklModel->pager;
      $page = $this->request->getVar('page') ? $this->request->getVar('page') : 1;
      $keterangan = "cariskl";
    } else {
      $folderskl = $this->filesklModel->paginate(30, 'folderskl');
      $pager = $this->filesklModel->pager;
      $page = $this->request->getVar('page') ? $this->request->getVar('page') : 1;
      $keterangan = "full";
      // $jumlah = "";
    }


    // $folderbuku = directory_map('assets/buku/buku/');
    // $folderbuku = $this->filebukuModel->findAll();
    $datasekolah = $this->settingModel->get()->getRowArray();

    $data = [
      'title' => "File Manager SKL " . $datasekolah['nama_sekolah'],
      'datasekolah' => $datasekolah,
      'folderskl' => $folderskl,
      'pager' => $pager,
      'page' => $page,
      'keterangan' => $keterangan,
      'skllink' => $skllink,
      'user' => $cekuser
      // 'jumlah' => $jumlah  
    ];

    // return view('sign_in', $data);
    return view('backend/fileskl', $data);
  }

  function download($id)
  {

    $data = $this->filesklModel->find($id);


    return $this->response->download('asset/skl/' . $data['fileskl'], null);
  }


  public function deletefile($namafile)
  {
    if ($this->request->isAJAX()) {

      // $detailbuku = $this->bukuModel->where('buku', $namafile)->get()->getRowArray();
      $siswa = $this->siswaModel->where('nama_file', $namafile)->get()->getRowArray();

      $update = [
        'file_exist' => "kosong",
      ];


      if (file_exists('asset/skl/' . $namafile)) {
        $this->siswaModel->update($siswa['id'], $update);
        unlink('asset/skl/' . $namafile);
      }

      $this->filesklModel->where('fileskl', $namafile)->delete();
    } else {
      echo "No direct script access allowed";
    }
  }




  public function addfile()
  {


    $image = $this->request->getFile('file');

    $imageName = $image->getClientName();

    $judulsklada = $this->filesklModel->findColumn('fileskl');

    if (in_array($imageName, $judulsklada)) {
      return json_encode(array(
        "status" => 0,
        "filename" => $imageName,
      ));
    } else {
      // $judulbuku = $this->bukuModel->where('buku', $imageName)->get()->getRowArray();
      $siswa = $this->siswaModel->where('nama_file', $imageName)->get()->getRowArray();

      $update = [
        'file_exist' => "ada",
      ];

      $this->siswaModel->update($siswa['id'], $update);

      $image->move('asset/skl', $imageName);

      // $imageUpload = new ImageUpload();

      $insert = [
        'fileskl' => $imageName
      ];

      $this->filesklModel->insert($insert);

      return json_encode(array(
        "status" => 1,
        "filename" => $imageName,

      ));
    }
  }
}
