<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->

    <div class="row">
      <div class="col align-self-end mb-3">
        <div class="col-md-4">
          <div class="form-group row">
            <label for="bulan" class="col-sm-2 col-form-label">Bulan</label>
            <div class="col-sm-4">
              <input type="text" class="form-control" id="searchbulan" name="searchbulan">
            </div>
            <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
            <div class="col-sm-4">
              <input type="text" class="form-control" id="searchtahun" name="searchtahun">
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableAbsenKeuangan">
            <thead class="bg-navy">
              <tr>
                <!-- <th scope="col">No</th>
                <th><input type="checkbox" id='checkall'></th> -->
                <th scope="col">No</th>
                <th scope="col">NIP</th>
                <th scope="col">Nama Lengkap</th>
                <th scope="col">Gol.</th>
                <th scope="col">Bulan</th>
                <th scope="col">Tahun</th>
                <th scope="col">50%</th>
                <th scope="col">BKK</th>
                <th scope="col">M.Puasa</th>
                <th scope="col">M.Security</th>
                <th scope="col">Transport</th>
                <th scope="col">Created At</th>
                <th scope="col">Updated At</th>
                <th scope="col">Last User Update</th>

              </tr>
            </thead>


          </table>
        </div>


      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->



<script>
  $(document).ready(function() {


    function tabelabsen(dataks) {
      let i = "1";
      $('#tableAbsenKeuangan').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'copyHtml5',
            text: '<i class="far fa-fw fa-copy"></i>',
            titleAttr: 'Copy'
          },
          {
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel'
          },
          {
            extend: 'pdfHtml5',
            text: '<i class="far fa-fw fa-file-pdf"></i>',
            titleAttr: 'Pdf'
          },
          {
            extend: 'print',
            text: '<i class="fas fa-fw fa-print"></i>',
            titleAttr: 'Print'
          },
          {
            extend: 'colvis',
            text: '',
            titleAttr: 'Colvis'
          }
        ],

        "columns": [{
            "data": null,
            "render": function() {
              return a = i++;
            }
          },

          {
            "data": "nip"
          },
          {
            "data": "karyawan"
          },
          {
            "data": "gol_gaji"
          },
          {
            "data": "bulan"
          },
          {
            "data": "tahun"
          },
          {
            "data": "setengah"
          },
          {
            "data": "bkk"
          },
          {
            "data": "makan_puasa"
          },
          {
            "data": "security"
          },
          {
            "data": "transport"
          },
          {
            "data": "created_at"
          },
          {
            "data": "updated_at"
          },
          {
            "data": "user_update"

          }

        ],

      });
    }

    //fungsi fetch absen
    function fetchAbsen() {
      $.ajax({
        url: '<?= base_url(); ?>/keuangan/fetchabsenpegawai',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          tabelabsen(data.absen);
        }
      });
    }

    fetchAbsen();

    // #column3_search is a <input type="text"> element
    $('#searchbulan').on('keyup', function() {
      $('#tableAbsenKeuangan').DataTable()
        .columns(4)
        .search(this.value)
        .draw();
    });

    $('#searchtahun').on('keyup', function() {
      $('#tableAbsenKeuangan').DataTable()
        .columns(5)
        .search(this.value)
        .draw();
    });

  });
</script>

<?= $this->endSection(); ?>