<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col-md-8"></div>
      <div class="col-md-4 float-right">
        <div class="form-group row">
          <label for="bulan" class="col-sm-2 col-form-label">Bulan</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="searchbulan" name="searchbulan">
          </div>
          <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="searchtahun" name="searchtahun">
          </div>
        </div>
      </div>
    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableSlip">
            <thead class="bg-navy">
              <tr>
                <th scope="col">No</th>
                <th scope="col">Action</th>
                <th scope="col">No Gaji</th>
                <th scope="col">NIP</th>
                <th scope="col">Nama</th>
                <th scope="col">Jabatan</th>
                <th scope="col">Bulan</th>
                <th scope="col">Tahun</th>
                <th scope="col">Gaji Pokok</th>
                <th scope="col">Tunj. Jabatan</th>
                <th scope="col">Tunj. Profesi</th>
                <th scope="col">Tunj. Kinerja</th>
                <th scope="col">Tunj. Tugas</th>
                <th scope="col">Tunj. Komunikasi</th>
                <th scope="col">bkk</th>
                <th scope="col">Jumlah Gaji</th>
                <th scope="col">Jumlah Kehadiran</th>
                <th scope="col">Tunj. Kehadiran</th>
                <th scope="col">Jumlah Puasa</th>
                <th scope="col">Tunj. Puasa</th>
                <th scope="col">Jumlah Tunjangan</th>
                <th scope="col">Gaji Kotor</th>
                <th scope="col">spp</th>
                <th scope="col">Uang Pangkal</th>
                <th scope="col">Uang KBM</th>
                <th scope="col">Tagihan Komunikasi</th>
                <th scope="col">Dana Sosial</th>
                <th scope="col">Simpanan Pokok</th>
                <th scope="col">Cicilan</th>
                <th scope="col">Kupon Belanja</th>
                <th scope="col">Tab. Koperasi</th>
                <th scope="col">BPJS Tenaga Kerja</th>
                <th scope="col">BPJS Kesehatan</th>
                <th scope="col">Zakat Profesi</th>
                <th scope="col">Qurban</th>
                <th scope="col">dll</th>
                <th scope="col">Juml. Potongan</th>
                <th scope="col">Gaji diterima</th>
                <th scope="col">Created At</th>
                <th scope="col">Updated At</th>
                <th scope="col">Last User Update</th>
              </tr>
            </thead>

          </table>
        </div>


      </div>
    </div>



  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->


<script>
  $(document).ready(function() {

    function tabelslip(dataks) {
      let i = 1;
      $('#tableSlip').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [
          'copy', 'excel', 'pdf'
        ],

        columnDefs: [{
          targets: [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35],
          visible: false
        }],

        "columns": [{
            "data": null,
            "render": function() {
              return a = i++;
            }
          },
          {
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                            <center>
                            <a href="<?= base_url(); ?>/keuangan/detailslip/${row.id}&${row.id_karyawan}" target="_blank" class="badge badge-success detailslip" target="blank"><i class="fas fa-fw fa-search"></i></a>
                           
                            <a href="<?= base_url(); ?>/keuangan/pdfdetailslip/${row.id}&${row.id_karyawan}" target="_blank" class="badge badge-warning"><i class="fas fa-fw fa-download"></i></a>
                            </center>`

              return a;
            }
          },
          {
            "data": "nogaji"
          },
          {
            "data": "nip"
          },
          {
            "data": "nama_lengkap"
          },
          {
            "data": "jabatan"
          },
          {
            "data": "bulan"
          },
          {
            "data": "tahun"
          },
          {
            "data": "gapok"
          },
          {
            "data": "tunjjabatan"
          },
          {
            "data": "tunjprofesi"
          },
          {
            "data": "tunjkinerja"
          },
          {
            "data": "tunjtgs"
          },
          {
            "data": "tunjkomunikasi"
          },
          {
            "data": "bkk"
          },
          {
            "data": "jmlhgaji"
          },
          {
            "data": "jmlhkehadiran"
          },
          {
            "data": "tunjkehadiran"
          },
          {
            "data": "jmlhpuasa"
          },
          {
            "data": "tunjpuasa"
          },
          {
            "data": "jmlhtunjangan"
          },
          {
            "data": "jmlhgator"
          },
          {
            "data": "spp"
          },
          {
            "data": "uangpangkal"
          },
          {
            "data": "uangkbm"
          },
          {
            "data": "tagihankomunikasi"
          },
          {
            "data": "danasosial"
          },
          {
            "data": "simpananpokok"
          },
          {
            "data": "cicilan"
          },
          {
            "data": "kuponbelanja"
          },
          {
            "data": "tabungankoperasi"
          },
          {
            "data": "bpjstenaga"
          },
          {
            "data": "bpjskesehatan"
          },
          {
            "data": "zakatprofesi"
          },
          {
            "data": "qurban"
          },
          {
            "data": "dll"
          },
          {
            "data": "jmlhpotongan"
          },
          {
            "data": "jmlhgajiditerima"
          },

          {
            "data": "created_at"
          },
          {
            "data": "updated_at"
          },
          {
            "data": "user_update"

          }

        ]
      });
    }

    //fetch SLip
    function fetchSlip() {
      $.ajax({
        url: '<?= base_url(); ?>/profil/fetchslip',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          // let i = "1";
          tabelslip(data.slip);
        }
      });
    }

    fetchSlip();

    // #column3_search is a <input type="text"> element
    $('#searchbulan').on('keyup', function() {
      $('#tableSlip').DataTable()
        .columns(6)
        .search(this.value)
        .draw();
    });

    $('#searchtahun').on('keyup', function() {
      $('#tableSlip').DataTable()
        .columns(7)
        .search(this.value)
        .draw();
    });


  });
</script>

<?= $this->endSection(); ?>