<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row justify-content-between">
      <div class="col-md-4 mb-3">
        <!-- Button trigger modal -->

        <button type="button" id="btntambahpangkatbaru" class="btn btn-primary" data-toggle="modal" data-target="#tambahModal">
          Tambah
        </button>
        <button type="button" name="btndeletepangkat" id="btndeletepangkat" class="btn btn-danger">Hapus</button>
        <button type="button" id="btnimportpangkatbaru" class="btn btn-info" data-toggle="modal" data-target="#importModal">
          Import
        </button>

        <!-- modal import -->
        <div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="importModalLabel">Import Data Pangkat Pegawai</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <!-- Form Tambah Data -->
                <form action="" method="POST" id="importpangkatpegawai" enctype="multipart/form-data">
                  <div class="form_group" style="margin-bottom: 5;">
                    <label for="">Unggah File</label>
                    <input type="file" id="filepangkatpegawai" name="filepangkatpegawai" class="form-control">
                  </div>
                  <br>
                  <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_pangkat_pegawai.xls">Download Template Import Pangkat Pegawai</a></p>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" id="btnimportpangkat" class="btn btn-primary">Import</button>
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>
      <!-- <div class="col-md-4"></div> -->
      <div class="col-md-4 ">
        <div class="form-group row">
          <label for="bulan" class="col-sm-2 col-form-label"></label>
          <div class="col-sm-4">

          </div>
          <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="searchtahun" name="searchtahun">
          </div>
        </div>
      </div>


    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tablePangkatPegawai">
            <thead class="bg-navy">
              <tr>
                <th scope="col"></th>
                <th><input type="checkbox" id='checkall'></th>
                <!-- <th scope="col">No</th> -->
                <th scope="col">Action</th>
                <th scope="col">NIP</th>
                <th scope="col">Nama Lengkap</th>
                <th scope="col">TMT</th>
                <th scope="col">Tahun</th>
                <th scope="col">Pangkat</th>

              </tr>
            </thead>


          </table>
        </div>


      </div>
    </div>


    <!-- Modal Tambah Nilai -->
    <div class="modal fade" id="tambahModal" tabindex="-1" aria-labelledby="tambahModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="tambahModalLabel">Tambah Pangkat</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">

            <form method="post" action="" id="tambahpangkatform">

              <div class="form-group row">
                <label for="namalengkap" class="col-sm-2 control-label">Nama Lengkap</label>
                <div class="col-sm-10">
                  <select id="namalengkap" class="form-control selectnamalengkap" name="namalengkap" onchange="tampil()">
                    <option selected disabled>Choose...</option>
                    <?php foreach ($pegawai as $pegawai) : ?>
                      <option value="<?= $pegawai['nip']; ?>"><?= $pegawai['nama_lengkap']; ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div>

              <div class="form-group row">
                <label for="nip" class="col-sm-2">NIP</label>
                <div class="col-sm-4">
                  <p id="textnip">NIP Pegawai</p>
                  <input type="hidden" class="form-control" id="nip" name="nip">
                </div>
              </div>
              <div class="form-group row">
                <label for="tmt" class="col-sm-2 col-form-label">TMT</label>
                <div class="col-sm-4">
                  <!-- <input type="text" class="form-control" id="tahun" name="tahun"> -->
                  <input type="date" name="tmt" placeholder="TMT" class="form-control" id="date">
                </div>
              </div>


              <div class="form-group row">
                <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
                <div class="col-sm-4">
                  <input type="text" class="form-control" id="tahun" name="tahun">
                </div>
              </div>

              <div class="form-group row">
                <label for="pangkat" class="col-sm-2 col-form-label">Pangkat</label>
                <div class="col-sm-4">
                  <!-- <input type="text" class="form-control" id="pangkat" name="pangkat"> -->
                  <select name="pangkat" class="form-control">
                    <option selected disabled>--- Pangkat ---</option>

                    <?php foreach ($pangkat as $pangkatj) : ?>
                      <option value="<?= $pangkatj['golongan']; ?>"><?= $pangkatj['golongan']; ?></option>
                    <?php endforeach; ?>

                  </select>
                </div>
              </div>


          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btnsavepangkat" class="btn btn-primary">Tambah</button>
          </div>


          </form>
        </div>
      </div>
    </div>

    <!-- Modal Edit Absen -->
    <div class="modal fade" id="editpangkatModal" tabindex="-1" aria-labelledby="editpangkatModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editpangkatModalLabel">Edit Pangkat</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">

            <form method="post" action="" id="editpangkatform">
              <input type="hidden" name="iddaftarpangkat">
              <div class="form-group row">
                <label for="nip" class="col-sm-2">NIP</label>
                <div class="col-sm-10">
                  <p id="edittextnip">NIP Pegawai</p>
                  <input type="hidden" class="form-control" name="nip">
                </div>
                <label for="nip" class="col-sm-2">Nama</label>
                <div class="col-sm-4">
                  <input type="text" class="form-control" name="karyawan" readonly>
                </div>
              </div>



              <div class="form-group row">
                <label for="tmt" class="col-sm-2 col-form-label">TMT</label>
                <div class="col-sm-4">
                  <!-- <input type="text" class="form-control" id="tahun" name="tahun"> -->
                  <input type="date" name="tmt" placeholder="TMT" class="form-control">
                </div>
              </div>


              <div class="form-group row">
                <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
                <div class="col-sm-4">
                  <input type="text" class="form-control" name="tahun">
                </div>
              </div>

              <div class="form-group row">
                <label for="pangkat" class="col-sm-2 col-form-label">Pangkat</label>
                <div class="col-sm-4">
                  <!-- <input type="text" class="form-control" id="pangkat" name="pangkat"> -->
                  <select name="pangkat" id="editpangkat" class="form-control">
                    <option selected disabled>--- Pangkat ---</option>

                    <!-- <?php foreach ($pangkat as $pangkatj) : ?>
                      <option value="<?= $pangkatj['golongan']; ?>"><?= $pangkatj['golongan']; ?></option>
                    <?php endforeach; ?> -->

                  </select>
                </div>
              </div>



          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btnupdatepangkat" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
  function tampil() {
    let nip = document.getElementById("namalengkap").value;
    // console.log(nip)
    document.getElementById("textnip").innerHTML = nip;
    document.getElementById("nip").value = nip;
  }
</script>

<script>
  $(document).ready(function() {

    $('.selectnamalengkap').select2({
      theme: "bootstrap"
    });


    function tabelpangkat(dataks) {
      $('#tablePangkatPegawai').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'copyHtml5',
            text: '<i class="far fa-fw fa-copy"></i>',
            titleAttr: 'Copy'
          },
          {
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel'
          },
          {
            extend: 'pdfHtml5',
            text: '<i class="far fa-fw fa-file-pdf"></i>',
            titleAttr: 'Pdf'
          },
          {
            extend: 'print',
            text: '<i class="fas fa-fw fa-print"></i>',
            titleAttr: 'Print'
          },
          {
            extend: 'colvis',
            text: '',
            titleAttr: 'Colvis'
          }
        ],

        columnDefs: [{
          className: "text-center",
          targets: "_all"
        }],


        "columns": [{
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              return a;
            }
          },
          {
            targets: 0,
            data: null,
            className: 'text-center',
            searchable: false,
            orderable: false,

            "render": function(data, type, row, meta) {
              var r =
                '<input type="checkbox" name="deletecheckbox" id = "' + row.id + '"  value = "' + row.id + '" class="deletecheckbox"></input>';

              return r;
            },
          },
          {
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                            <center><a href="" class="badge badge-info editpangkatpegawai" value="${row.id}"><i class="far fa-fw fa-edit"></i></a></center>`

              return a;
            }
          },

          {
            "data": "nip"
          },
          {
            "data": "nama"
          },
          {
            "data": "tmt"
          },
          {
            "data": "tahun"
          },
          {
            "data": "pangkat"
          }


        ],

      });
    }


    //fungsi fetch absen
    function fetchPangkat() {
      $.ajax({
        url: '<?= base_url(); ?>/pegawai/fetchdaftarpangkatpegawai',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          tabelpangkat(data.pangkat);
        }
      });
    }

    fetchPangkat();

    // #column3_search is a <input type="text"> element


    $('#searchtahun').on('keyup', function() {
      $('#tablePangkatPegawai').DataTable()
        .columns(5)
        .search(this.value)
        .draw();
    });

    $(document).on('click', '#btntambahpangkatbaru', function() {
      $('#tambahpangkatform')[0].reset();
    })

    $(document).on('click', '#btnimportpangkatbaru', function() {
      $('#importpangkatpegawai')[0].reset();
    })

    // tambah nilai
    $('#tambahpangkatform').submit(function() {
      event.preventDefault();

      $.ajax({
        url: '<?= base_url('/pegawai/savedaftarpangkatpegawai'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnsavepangkat').attr('disabled');
          $("#btnsavepangkat").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tambahModal').modal('hide');
            $('#tablePangkatPegawai').DataTable().destroy();

            fetchPangkat();
            toastr["success"](data.pesan);
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnsavepangkat').removeAttr('disabled');
          $("#btnsavepangkat").html(`Simpan`);

        },
      });
    });

    // modal edit
    $(document).on("click", ".editpangkatpegawai", function() {
      event.preventDefault();
      $("#editpangkat").children().remove();
      let iddaftarpangkat = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/pegawai/editmodaldaftarpangkat'); ?>',
        type: 'post',
        data: {
          iddaftarpangkat: iddaftarpangkat
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            // console.log(data);
            $('#editpangkatModal').modal('show');
            $("input[name='iddaftarpangkat']").val(data.pangkat.id);

            $("input[name='nip']").val(data.pangkat.nip);
            $("input[name='karyawan']").val(data.pangkat.nama);

            $("#edittextnip").text(data.pangkat.nip);

            $("input[name='tmt']").val(data.pangkat.tmt);
            $("input[name='tahun']").val(data.pangkat.tahun);

            $("input[name='pangkat']").val(data.pangkat.pangkat);


            var c;
            for (c = 0; c < data.nama_pangkat.length; c++) {
              $("#editpangkat").append('<option value="' + data.nama_pangkat[c] + '"' + ((data.pangkat.pangkat == data.nama_pangkat[c]) ? 'selected="selected"' : '') + '>' + data.nama_pangkat[c] + '</option>');

            }


          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // edit absen

    $("#editpangkatform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/pegawai/editdaftarpangkatpegawai',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnupdatepangkat').attr('disabled');
          $("#btnupdatepangkat").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editpangkatModal').modal('hide');
            $('#tablePangkatPegawai').DataTable().destroy();
            fetchPangkat();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }
          $('#tambahpangkatform')[0].reset();
        },
        complete: function() {
          $('#btnupdatepangkat').removeAttr('disabled');
          $("#btnupdatepangkat").html(`Update`);

        },

      });
    })

    // Check all 
    $('#checkall').click(function() {
      if ($(this).is(':checked')) {
        $('.deletecheckbox').prop('checked', true);
      } else {
        $('.deletecheckbox').prop('checked', false);
      }
    });

    $('.deletecheckbox').click(function() {
      if ($(this).is(':checked')) {
        $(this).closest('tr').addClass('removeRow');
      } else {
        $(this).closest('tr').removeClass('removeRow');
      }
    });


    $('#btndeletepangkat').click(function() {
      let checkbox = $('.deletecheckbox:checked');

      if (checkbox.length > 0) {
        Swal.fire({
          title: 'Apa kamu yakin ingin menghapus ' + checkbox.length + ' daftar pangkat pegawai?',
          text: "kamu tidak akan bisa mengembalikannya!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, hapus saja!'
        }).then((result) => {
          if (result.isConfirmed) {

            let checkbox_value = [];
            $(checkbox).each(function() {
              checkbox_value.push($(this).val());
            });

            // console.log(checkbox);
            $.ajax({
              url: '<?= base_url('/pegawai/deletedaftarpangkatpegawai'); ?>',
              type: "POST",
              data: {
                checkbox_value: checkbox_value
              },
              dataType: 'json',
              success: function(data) {
                if (data.responce == "success") {

                  Swal.fire(
                    'Deleted!',
                    'Data berhasil dihapus.',
                    'success'
                  )
                  $('#tablePangkatPegawai').DataTable().destroy();
                  fetchPangkat();
                } else {
                  Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Ada yang tidak beres!',
                  })
                }
              }
            })

          }
        })

      } else {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: 'Pilih minimal satu data',
        })

      }
    });


    // import pegawai
    $('#importpangkatpegawai').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/pegawai/importdaftarpangkatpegawai'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnimportpangkat').attr('disabled');
          $("#btnimportpangkat").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "errorkosong") {

            $('#importModal').modal('hide');
            Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: 'Nip atau pangkat tidak ada di database pada baris ' + data.barisgagal
            })

          } else if (data.responce == "success") {


            $('#tablePangkatPegawai').DataTable().destroy();
            fetchPangkat();
            $('#importModal').modal('hide');
            toastr["success"](data.pesan);

          } else {
            console.log(data);
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnimportpangkat').removeAttr('disabled');
          $("#btnimportpangkat").html(`Update`);

        },
      });

    });



  });
</script>

<?= $this->endSection(); ?>