<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">


        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">

                    <div class="col">
                        <button type="button" id="btntambahfile" class="btn btn-primary" data-toggle="modal" data-target="#tambahDownloadModal">
                            Tambah
                        </button>

                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahDownloadModal" tabindex="-1" aria-labelledby="tambahDownloadModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahDownloadModalLabel">Tambah Form Download</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahdownloadform">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="Judul" class="col-sm-2 col-form-label">Judul</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="judul">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="url" class="col-sm-2 col-form-label">Url</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="textbox" class="form-control"> -->
                                                <textarea class="form-control" name="url" rows="3"></textarea>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnsimpan">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editDownloadModal" tabindex="-1" aria-labelledby="editDownloadModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editDownloadModalLabel">Edit Form Download</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editdownloadform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="iddownload">
                                        <div class="form-group row">
                                            <label for="judul" class="col-sm-2 col-form-label">Judul</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="judul">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="url" class="col-sm-2 col-form-label">Url</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" name="url" id="editurl" rows="3"></textarea>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnedit">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelDownload">
                                <thead class="bg-success">
                                    <tr>
                                        <!-- <th><input type="checkbox" id='checkall'></th> -->
                                        <th scope="col">No</th>
                                        <th scope="col">Judul</th>
                                        <th scope="col">Url</th>
                                        <th scope="col">Sort</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
    $(document).ready(function() {

        function tabeldownload(dataks) {
            let i = 1
            $('#tabelDownload').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "judul"
                    },
                    {
                        "data": "url"
                    },
                    {
                        "data": "sort"
                    },

                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                   
                                    <a href="" value="${row.id}" class="badge badge-info editdownload"><i class="fas fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletedownload"><i class="fas fa-fw fa-trash"></i></a>

                                    `

                            return a;
                        }
                    },
                ]
            });
        }


        //fetch Jadwal semua
        function fetchDownload() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/berkas/fetchdownload',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    tabeldownload(data.download)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchDownload();

        $(document).on('click', '#btntambahfile', function() {
            $('#tambahdownloadform')[0].reset();
        })

        // save download
        $('#tambahdownloadform').submit(function() {
            event.preventDefault();

            $.ajax({
                url: '<?= base_url('/berkas/savedownload'); ?>',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                // data: $(this).serialize(),
                beforeSend: function() {
                    // setting a timeout
                    $('#btnsimpan').attr('disabled');
                    $("#btnsimpan").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahDownloadModal').modal('hide');
                        $('#tabelDownload').DataTable().clear();
                        $('#tabelDownload').DataTable().destroy();
                        fetchDownload();
                        toastr["success"](data.pesan);
                    } else {
                        // console.log(data);
                        toastr["error"](data.pesan);
                    }
                },
                complete: function() {
                    $('#btnsimpan').removeAttr('disabled');
                    $("#btnsimpan").html(`Simpan`);

                },
            });

        });

        // modal edit
        $(document).on("click", ".editdownload", function() {
            event.preventDefault();
            $('#editdownloadform')[0].reset();
            let iddownload = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/berkas/editdownloadmodal'); ?>',
                type: 'post',
                data: {
                    iddownload: iddownload
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        $('#editDownloadModal').modal('show');
                        $("input[name='iddownload']").val(data.download.id);
                        $("input[name='judul']").val(data.download.judul);
                        $("#editurl").html(data.download.url);
                        $("input[name='sort']").val(data.download.sort);

                    } else {
                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        // edit download

        $("#editdownloadform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/berkas/editdownload',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    // setting a timeout
                    $('#btnedit').attr('disabled');
                    $("#btnedit").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editDownloadModal').modal('hide');
                        $('#tabelDownload').DataTable().destroy();
                        fetchDownload();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                },
                complete: function() {
                    $('#btnedit').removeAttr('disabled');
                    $("#btnedit").html(`Update`);
                },

            });
        })

        // delete jadwal
        $(document).on("click", ".deletedownload", function() {
            event.preventDefault();
            let iddownload = $(this).attr('value');

            Swal.fire({
                title: 'Apa kamu yakin untuk menghapusnya?',
                text: "kamu tidak akan bisa mengembalikannya",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus saja!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?= base_url('/berkas/deletedownload'); ?>/' + iddownload,
                        type: 'DELETE',
                        error: function() {
                            alert('Something is wrong');
                        },
                        success: function(data) {
                            $('#tabelDownload').DataTable().destroy();
                            fetchDownload();
                            Swal.fire(
                                'Deleted!',
                                'File sudah terdelete.',
                                'success'
                            )
                        }
                    });

                }
            })
        });

    })
</script>

<?= $this->endSection(); ?>